<?php
/**
 * ISC License
 *
 * Copyright (c) 2025 idnovate.com
 * idnovate is a Registered Trademark & Property of idnovate.com, innovación y desarrollo SCP
 *
 * Permission to use, copy, modify, and/or distribute this software for any
 * purpose with or without fee is hereby granted, provided that the above
 * copyright notice and this permission notice appear in all copies.
 *
 * THE SOFTWARE IS PROVIDED "AS IS" AND THE AUTHOR DISCLAIMS ALL WARRANTIES WITH
 * REGARD TO THIS SOFTWARE INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY
 * AND FITNESS. IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY SPECIAL, DIRECT,
 * INDIRECT, OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM
 * LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR
 * OTHER TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
 * PERFORMANCE OF THIS SOFTWARE.
 *
 * @author    idnovate
 * @copyright 2025 idnovate.com
 * @license   https://www.isc.org/licenses/ https://opensource.org/licenses/ISC ISC License
 */
if (!defined('_PS_VERSION_')) {
    exit;
}

class AdminAdvancedPopupCreatorConfigurationController extends ModuleAdminController
{
    protected $isShopSelected = true;

    public function __construct()
    {
        $this->bootstrap = true;
        $this->tabClassName = 'AdminAdvancedPopupCreatorConfiguration';

        parent::__construct();
    }

    public function setMedia($isNewTheme = false)
    {
        parent::setMedia($isNewTheme);

        $this->addJS(_MODULE_DIR_ . $this->module->name . '/views/js/tabs.js', false);
        $this->addJS(_MODULE_DIR_ . $this->module->name . '/lib/CodeMirror/lib/codemirror.js');
        $this->addJS(_MODULE_DIR_ . $this->module->name . '/lib/CodeMirror/addon/display/autorefresh.js');
        $this->addJS(_MODULE_DIR_ . $this->module->name . '/lib/CodeMirror/mode/css/css.js');

        if (version_compare(_PS_VERSION_, '1.6', '<')) {
            $this->addCSS(_MODULE_DIR_ . $this->module->name . '/views/css/tabs.css');
        }

        $this->addCSS(_MODULE_DIR_ . $this->module->name . '/lib/CodeMirror/lib/codemirror.css');
        $this->addCSS(_MODULE_DIR_ . $this->module->name . '/lib/CodeMirror/theme/monokai.css');
    }

    public function initPageHeaderToolbar()
    {
        parent::initPageHeaderToolbar();

        if (empty($this->display)) {
            $this->page_header_toolbar_btn['desc-module-translate'] = [
                'href' => '#',
                'desc' => $this->module->l('Translate'),
                'modal_target' => '#moduleTradLangSelect',
                'icon' => 'process-icon-flag',
            ];

            $this->page_header_toolbar_btn['desc-module-hook'] = [
                'href' => 'index.php?tab=AdminModulesPositions&token=' . Tools::getAdminTokenLite('AdminModulesPositions') . '&show_modules=' . Module::getModuleIdByName($this->module->name),
                'desc' => $this->module->l('Manage hooks'),
                'icon' => 'process-icon-anchor',
            ];
        }

        $this->context->smarty->clearAssign('help_link', '');
    }

    public function initModal()
    {
        parent::initModal();

        $languages = Language::getLanguages(false);
        $translateLinks = [];

        if (version_compare(_PS_VERSION_, '1.7.2.1', '>=')) {
            $isNewTranslateSystem = $this->module->isUsingNewTranslationSystem();
            $link = Context::getContext()->link;
            foreach ($languages as $lang) {
                if ($isNewTranslateSystem) {
                    $translateLinks[$lang['iso_code']] = $link->getAdminLink('AdminTranslationSf', true, [
                        'lang' => $lang['iso_code'],
                        'type' => 'modules',
                        'selected' => $this->module->name,
                        'locale' => $lang['locale'],
                    ]);
                } else {
                    $translateLinks[$lang['iso_code']] = $link->getAdminLink('AdminTranslations', true, [], [
                        'type' => 'modules',
                        'module' => $this->module->name,
                        'lang' => $lang['iso_code'],
                    ]);
                }
            }
        }

        $this->context->smarty->assign([
            'trad_link' => 'index.php?tab=AdminTranslations&token=' . Tools::getAdminTokenLite('AdminTranslations') . '&type=modules&module=' . $this->module->name . '&lang=',
            'module_languages' => $languages,
            'module_name' => $this->module->name,
            'translateLinks' => $translateLinks,
        ]);

        $modal_content = $this->context->smarty->fetch($this->module->getLocalPath() . 'views/templates/admin/modal_translation.tpl');

        $this->modals[] = [
            'modal_id' => 'moduleTradLangSelect',
            'modal_class' => 'modal-sm',
            'modal_title' => $this->module->l('Translate this module'),
            'modal_content' => $modal_content,
        ];
    }

    public function initContent()
    {
        if (!$this->isShopSelected && !$this->display) {
            $this->informations[] = $this->module->l('You have to select a shop.');
        }

        $warningError = '';
        /*if ($warnings = $this->module->getWarnings(false)) {
            $warningError = $this->module->displayError($warnings);
        }*/

        if (Tools::isSubmit('submitAdvancedPopupCreatorOverrideHook')) {
            // Define the source and destination folder names
            $sourceFolder = _PS_MODULE_DIR_ . $this->module->name . '/override_';
            $destinationFolder = _PS_MODULE_DIR_ . $this->module->name . '/override';

            // Check if the source folder exists
            if (is_dir($sourceFolder)) {
                // Attempt to rename the folder
                if (!rename($sourceFolder, $destinationFolder)) {
                    return false;
                }
            }

            $this->module->addOverride('Hook');

            $sourceFolder = _PS_MODULE_DIR_ . $this->module->name . '/override';
            $destinationFolder = _PS_MODULE_DIR_ . $this->module->name . '/override_';

            // Check if the source folder exists
            if (is_dir($sourceFolder)) {
                // Attempt to rename the folder
                if (!rename($sourceFolder, $destinationFolder)) {
                    return false;
                }
            }
        }

        if (Tools::isSubmit('submitAdvancedPopupCreatorRemoveOverrideHook')) {
            // Define the source and destination folder names
            $sourceFolder = _PS_MODULE_DIR_ . $this->module->name . '/override_';
            $destinationFolder = _PS_MODULE_DIR_ . $this->module->name . '/override';

            // Check if the source folder exists
            if (is_dir($sourceFolder)) {
                // Attempt to rename the folder
                if (!rename($sourceFolder, $destinationFolder)) {
                    return false;
                }
            }

            $this->module->removeOverride('Hook');

            $sourceFolder = _PS_MODULE_DIR_ . $this->module->name . '/override';
            $destinationFolder = _PS_MODULE_DIR_ . $this->module->name . '/override_';

            // Check if the source folder exists
            if (is_dir($sourceFolder)) {
                // Attempt to rename the folder
                if (!rename($sourceFolder, $destinationFolder)) {
                    return false;
                }
            }
        }

        if (Tools::isSubmit('submitAdvancedPopupCreatorConfiguration')) {
            $configurationFields = [
                'APC_BOOTSTRAP',
                'APC_HIDE_FILTER_CUSTOMER',
                'APC_HIDE_FILTER_CUSTOMER_GROUP',
                'APC_HIDE_FILTER_PRODUCT',
                'APC_HIDE_FILTER_CATEGORY',
                'APC_HIDE_FILTER_ATTRIBUTE',
                'APC_HIDE_FILTER_FEATURE',
                'APC_HIDE_FILTER_MANUFACTURER',
                'APC_HIDE_FILTER_SUPPLIER',
                'APC_COOKIE',
                'APC_UA',
                'APC_CSS',
                'APC_JS',
            ];

            foreach ($configurationFields as $configurationField) {
                Configuration::updateValue($configurationField, Tools::getValue($configurationField));
            }

            $this->content .= $this->module->displayConfirmation($this->module->l('Configuration successfully updated.'));
        }

        // $this->content .= $this->_createTemplate('admin_translations.tpl')->fetch();

        if (!$this->display) {
            $this->content .= $this->renderGlobalConfigForm();
        }

        parent::initContent();

        if (!$this->display) {
            if (version_compare(_PS_VERSION_, '1.6', '>=')) {
                $this->context->smarty->assign([
                    'this_path' => $this->module->getPathUri(),
                    'support_id' => $this->module->addons_id_product,
                ]);

                $available_iso_codes = ['en', 'es'];
                $default_iso_code = 'en';
                $template_iso_suffix = in_array($this->context->language->iso_code, $available_iso_codes) ? $this->context->language->iso_code : $default_iso_code;
                $this->content .= $this->context->smarty->fetch($this->module->getLocalPath() . '/views/templates/admin/company/information_' . $template_iso_suffix . '.tpl');
            }
        }

        $this->context->smarty->assign([
            'content' => $warningError . $this->content,
            'token' => $this->token,
        ]);
    }

    public function postProcess()
    {
        parent::postProcess();

        if (!empty($this->errors)) {
            // if we have errors, we stay on the form instead of going back to the list
            $this->display = 'edit';

            return false;
        }
    }

    protected function renderGlobalConfigForm()
    {
        $helper = new HelperForm();
        $helper->show_toolbar = false;
        $helper->module = $this->module;
        $helper->default_form_language = $this->context->language->id;
        $helper->allow_employee_form_lang = Configuration::get('PS_BO_ALLOW_EMPLOYEE_FORM_LANG', 0);
        $helper->identifier = $this->identifier;
        $helper->currentIndex = self::$currentIndex;
        $helper->submit_action = 'submitAdvancedPopupCreatorConfiguration';
        $helper->token = Tools::getAdminTokenLite($this->tabClassName);
        $helper->tpl_vars = [
            'fields_value' => $this->getGlobalConfigFormValues(),
            'languages' => $this->context->controller->getLanguages(),
            'id_language' => $this->context->language->id,
        ];

        return $helper->generateForm($this->getGlobalConfigForm());
    }

    protected function getGlobalConfigForm()
    {
        $fields = [];

        $fieldsFormIndex = 0;
        $fields[$fieldsFormIndex]['form'] = [
            'id_form' => 'aaa',
            'legend' => [
                'title' => $this->module->l('Advanced'),
                'icon' => 'icon-cogs',
            ],
            'input' => [
                [
                    'col' => 12,
                    'type' => 'free',
                    'label' => '',
                    'name' => 'APC_WARNING',
                    'class' => 't',
                    'lang' => true,
                ],
                [
                    'type' => (version_compare(_PS_VERSION_, '1.6', '>=')) ? 'switch' : 'radio',
                    'label' => $this->module->l('Add Bootstrap library'),
                    'name' => 'APC_BOOTSTRAP',
                    'values' => [
                        [
                            'id' => 'APC_BOOTSTRAP_on',
                            'value' => 1,
                            'label' => $this->module->l('Yes'), ],
                        [
                            'id' => 'APC_BOOTSTRAP_off',
                            'value' => 0,
                            'label' => $this->module->l('No'), ],
                    ],
                ],
                [
                    'type' => (version_compare(_PS_VERSION_, '1.6', '>=')) ? 'switch' : 'radio',
                    'label' => sprintf($this->module->l('Hide %s filter'), $this->module->l('Customer')),
                    'name' => 'APC_HIDE_FILTER_CUSTOMER',
                    'class' => 't',
                    'col' => 8,
                    'is_bool' => true,
                    'values' => [
                        [
                            'id' => 'APC_HIDE_FILTER_CUSTOMER_on',
                            'value' => 1,
                            'label' => $this->module->l('Enabled'),
                        ],
                        [
                            'id' => 'APC_HIDE_FILTER_CUSTOMER_off',
                            'value' => 0,
                            'label' => $this->module->l('Disabled'),
                        ],
                    ],
                ],
                [
                    'type' => (version_compare(_PS_VERSION_, '1.6', '>=')) ? 'switch' : 'radio',
                    'label' => sprintf($this->module->l('Hide %s filter'), $this->module->l('Customer group')),
                    'name' => 'APC_HIDE_FILTER_CUSTOMER_GROUP',
                    'class' => 't',
                    'col' => 8,
                    'is_bool' => true,
                    'values' => [
                        [
                            'id' => 'APC_HIDE_FILTER_CUSTOMER_GROUP_on',
                            'value' => 1,
                            'label' => $this->module->l('Enabled'),
                        ],
                        [
                            'id' => 'APC_HIDE_FILTER_CUSTOMER_GROUP_off',
                            'value' => 0,
                            'label' => $this->module->l('Disabled'),
                        ],
                    ],
                ],
                [
                    'type' => (version_compare(_PS_VERSION_, '1.6', '>=')) ? 'switch' : 'radio',
                    'label' => sprintf($this->module->l('Hide %s filter'), $this->module->l('Product')),
                    'name' => 'APC_HIDE_FILTER_PRODUCT',
                    'class' => 't',
                    'col' => 8,
                    'is_bool' => true,
                    'values' => [
                        [
                            'id' => 'APC_HIDE_FILTER_PRODUCT_on',
                            'value' => 1,
                            'label' => $this->module->l('Enabled'),
                        ],
                        [
                            'id' => 'APC_HIDE_FILTER_PRODUCT_off',
                            'value' => 0,
                            'label' => $this->module->l('Disabled'),
                        ],
                    ],
                ],
                [
                    'type' => (version_compare(_PS_VERSION_, '1.6', '>=')) ? 'switch' : 'radio',
                    'label' => sprintf($this->module->l('Hide %s filter'), $this->module->l('Category')),
                    'name' => 'APC_HIDE_FILTER_CATEGORY',
                    'class' => 't',
                    'col' => 8,
                    'is_bool' => true,
                    'values' => [
                        [
                            'id' => 'APC_HIDE_FILTER_CATEGORY_on',
                            'value' => 1,
                            'label' => $this->module->l('Enabled'),
                        ],
                        [
                            'id' => 'APC_HIDE_FILTER_CATEGORY_off',
                            'value' => 0,
                            'label' => $this->module->l('Disabled'),
                        ],
                    ],
                ],
                [
                    'type' => (version_compare(_PS_VERSION_, '1.6', '>=')) ? 'switch' : 'radio',
                    'label' => sprintf($this->module->l('Hide %s filter'), $this->module->l('Attribute')),
                    'name' => 'APC_HIDE_FILTER_ATTRIBUTE',
                    'class' => 't',
                    'col' => 8,
                    'is_bool' => true,
                    'values' => [
                        [
                            'id' => 'APC_HIDE_FILTER_ATTRIBUTE_on',
                            'value' => 1,
                            'label' => $this->module->l('Enabled'),
                        ],
                        [
                            'id' => 'APC_HIDE_FILTER_ATTRIBUTE_off',
                            'value' => 0,
                            'label' => $this->module->l('Disabled'),
                        ],
                    ],
                ],
                [
                    'type' => (version_compare(_PS_VERSION_, '1.6', '>=')) ? 'switch' : 'radio',
                    'label' => sprintf($this->module->l('Hide %s filter'), $this->module->l('Feature')),
                    'name' => 'APC_HIDE_FILTER_FEATURE',
                    'class' => 't',
                    'col' => 8,
                    'is_bool' => true,
                    'values' => [
                        [
                            'id' => 'APC_HIDE_FILTER_FEATURE_on',
                            'value' => 1,
                            'label' => $this->module->l('Enabled'),
                        ],
                        [
                            'id' => 'APC_HIDE_FILTER_FEATURE_off',
                            'value' => 0,
                            'label' => $this->module->l('Disabled'),
                        ],
                    ],
                ],
                [
                    'type' => (version_compare(_PS_VERSION_, '1.6', '>=')) ? 'switch' : 'radio',
                    'label' => sprintf($this->module->l('Hide %s filter'), $this->module->l('Manufacturer')),
                    'name' => 'APC_HIDE_FILTER_MANUFACTURER',
                    'class' => 't',
                    'col' => 8,
                    'is_bool' => true,
                    'values' => [
                        [
                            'id' => 'APC_HIDE_FILTER_MANUFACTURER_on',
                            'value' => 1,
                            'label' => $this->module->l('Enabled'),
                        ],
                        [
                            'id' => 'APC_HIDE_FILTER_MANUFACTURER_off',
                            'value' => 0,
                            'label' => $this->module->l('Disabled'),
                        ],
                    ],
                ],
                [
                    'type' => (version_compare(_PS_VERSION_, '1.6', '>=')) ? 'switch' : 'radio',
                    'label' => sprintf($this->module->l('Hide %s filter'), $this->module->l('Supplier')),
                    'name' => 'APC_HIDE_FILTER_SUPPLIER',
                    'class' => 't',
                    'col' => 8,
                    'is_bool' => true,
                    'values' => [
                        [
                            'id' => 'APC_HIDE_FILTER_SUPPLIER_on',
                            'value' => 1,
                            'label' => $this->module->l('Enabled'),
                        ],
                        [
                            'id' => 'APC_HIDE_FILTER_SUPPLIER_off',
                            'value' => 0,
                            'label' => $this->module->l('Disabled'),
                        ],
                    ],
                ],
                [
                    'type' => (version_compare(_PS_VERSION_, '1.6', '>=')) ? 'switch' : 'radio',
                    'label' => $this->module->l('Use $_COOKIE'),
                    'name' => 'APC_COOKIE',
                    'values' => [
                        [
                            'id' => 'APC_COOKIE_on',
                            'value' => 1,
                            'label' => $this->module->l('Yes'), ],
                        [
                            'id' => 'APC_COOKIE_off',
                            'value' => 0,
                            'label' => $this->module->l('No'), ],
                    ],
                ],
                [
                    'type' => 'textarea',
                    'label' => $this->module->l('Don\'t apply restrictions for these user agents (SEO)'),
                    'desc' => $this->module->l('Popup will not be displayed for these user agents') . PHP_EOL . $this->module->l('Separate each user agent with a "|" (pipe) character'),
                    'name' => 'APC_UA',
                    'class' => 't',
                ],
                [
                    'type' => 'textarea',
                    'label' => $this->module->l('Custom CSS Rules'),
                    'name' => 'APC_CSS',
                    'class' => 'codemirror codemirror-css',
                    'cols' => 100,
                    'rows' => 10,
                ],
                [
                    'type' => 'textarea',
                    'label' => $this->module->l('Custom JavaScript Code'),
                    'name' => 'APC_JS',
                    'class' => 'codemirror codemirror-js',
                    'cols' => 100,
                    'rows' => 10,
                ],
            ],
            'submit' => [
                'title' => $this->module->l('Save'),
                'type' => 'submit',
                'class' => (version_compare(_PS_VERSION_, '1.6', '>=')) ? 'btn btn-default pull-right' : 'button big',
                'name' => 'submitAdvancedPopupCreatorConfiguration',
            ],
        ];

        ++$fieldsFormIndex;
        $fields[$fieldsFormIndex]['form'] = [
            'legend' => [
                'title' => $this->module->l('Hooks'),
                'icon' => 'icon-link',
            ],
            'input' => [
                [
                    'col' => 12,
                    'type' => 'free',
                    'label' => '',
                    'name' => 'APC_HOOKS_LINK',
                    'class' => 't',
                    'lang' => true,
                ],
            ],
        ];

        return $fields;
    }

    protected function getGlobalConfigFormValues()
    {
        $configurationFields = [
            'APC_BOOTSTRAP',
            'APC_HIDE_FILTER_CUSTOMER',
            'APC_HIDE_FILTER_CUSTOMER_GROUP',
            'APC_HIDE_FILTER_PRODUCT',
            'APC_HIDE_FILTER_CATEGORY',
            'APC_HIDE_FILTER_ATTRIBUTE',
            'APC_HIDE_FILTER_FEATURE',
            'APC_HIDE_FILTER_MANUFACTURER',
            'APC_HIDE_FILTER_SUPPLIER',
            'APC_COOKIE',
            'APC_UA',
            'APC_CSS',
            'APC_JS',
        ];

        $fields_values = [];
        foreach ($configurationFields as $configurationField) {
            $fields_values[$configurationField] = Tools::getValue($configurationField, Configuration::get($configurationField));
        }

        $fields_values['APC_WARNING'] = $this->context->smarty->fetch(_PS_MODULE_DIR_ . $this->module->name . '/views/templates/admin/warning.tpl');

        $this->context->smarty->assign([
            'exec_override' => AdvancedPopupCreator::checkOverride('Hook', 'exec'),
            'hooks_job_link' => $this->context->link->getPageLink('index', true, (int) Configuration::get('PS_LANG_DEFAULT')) . '?displayHooks=1&token=' . Tools::getAdminToken($this->module->name),
        ]);

        $fields_values['APC_HOOKS_LINK'] = $this->context->smarty->fetch(_PS_MODULE_DIR_ . $this->module->name . '/views/templates/admin/hooks_link.tpl');

        return $fields_values;
    }
}
