<?php
/**
 * ISC License
 *
 * Copyright (c) 2025 idnovate.com
 * idnovate is a Registered Trademark & Property of idnovate.com, innovación y desarrollo SCP
 *
 * Permission to use, copy, modify, and/or distribute this software for any
 * purpose with or without fee is hereby granted, provided that the above
 * copyright notice and this permission notice appear in all copies.
 *
 * THE SOFTWARE IS PROVIDED "AS IS" AND THE AUTHOR DISCLAIMS ALL WARRANTIES WITH
 * REGARD TO THIS SOFTWARE INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY
 * AND FITNESS. IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY SPECIAL, DIRECT,
 * INDIRECT, OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM
 * LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR
 * OTHER TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
 * PERFORMANCE OF THIS SOFTWARE.
 *
 * @author    idnovate
 * @copyright 2025 idnovate.com
 * @license   https://www.isc.org/licenses/ https://opensource.org/licenses/ISC ISC License
 */
if (!defined('_PS_VERSION_')) {
    exit;
}

class AdvancedPopupCreatorPopupModuleFrontController extends ModuleFrontController
{
    public function init()
    {
        parent::init();

        header('X-Robots-Tag: noindex, nofollow', true);
    }

    public function postProcess()
    {
        // For powerfulformgenerator module
        if (Tools::getValue('pfg_form_id')) {
            require_once _PS_MODULE_DIR_ . 'powerfulformgenerator/classes/PFGRenderer.php';
            $renderer = new PFGRenderer(1);
            Tools::redirect('index');
        }

        if (Tools::getValue('getPopup')) {
            $loAPC = new AdvancedPopup();

            // Sanitize parameter
            $availablePopups = explode(',', Tools::getValue('availablePopups'));
            foreach ($availablePopups as $availablePopupKey => $availablePopup) {
                if (!(int) $availablePopup) {
                    unset($availablePopups[$availablePopupKey]);
                }
            }
            $availablePopups = implode(',', $availablePopups);
            $laPopups = $loAPC->getPopupToDisplay($availablePopups);

            $popups = [];

            if ($laPopups) {
                foreach ($laPopups as $laPopup) {
                    // Render and return data
                    $popups[] = json_encode([
                        'selector' => (Tools::getValue('event') == 4 && $laPopup['display_on_click'] == 1) ? $laPopup['display_on_click_selector'] : '',
                        'id' => $laPopup['id_advancedpopup'],
                        'secs_to_display_inactive' => $laPopup['secs_to_display_inactive'],
                    ]);
                }
            }

            echo json_encode([
                'hasError' => false,
                'popups' => $popups,
            ]);
            exit;
        }

        if (Tools::getValue('updateVisits')) {
            $loAPC = new AdvancedPopup();
            $loAPC->updateVisits();
        }

        if (Tools::getValue('markAsSeen')) {
            $loAPC = new AdvancedPopup();
            $popupId = (int) Tools::getValue('popupId');
            if (!$popupId
                || $popupId <= 0) {
                return false;
            }

            $popups = $loAPC->getApcCookiePopups();

            $liNow = time();

            $popups[$popupId]['last_displayed'] = $liNow;
            if (isset($popups[$popupId]['times_displayed'])) {
                ++$popups[$popupId]['times_displayed'];
            } else {
                $popups[$popupId]['times_displayed'] = 1;
            }
            // $popups[$popupId]['visits'] = 0;

            $loAPC->setApcCookiePopups($popups);

            echo json_encode([
                'hasError' => false,
                'errors' => '',
            ]);
            exit;
        }

        if (Tools::getValue('dontDisplayAgain')) {
            $loAPC = new AdvancedPopup();
            $popups = $loAPC->getApcCookiePopups();

            $lbFound = false;
            if (!empty($popups)) {
                foreach ($popups as $laPopupId => &$popup) {
                    if ((int) $laPopupId === (int) Tools::getValue('popupId')) {
                        $lbFound = true;
                        $popup['last_displayed'] = PHP_INT_MAX - 1;
                    }
                }
                unset($popup);

                // Save if found id
                if ($lbFound) {
                    $loAPC->setApcCookiePopups($popups);
                }
            }
        }

        echo json_encode([
            'hasError' => false,
            'errors' => '',
        ]);
        exit;
    }
}
