{**
 * ISC License
 *
 * Copyright (c) 2025 idnovate.com
 * idnovate is a Registered Trademark & Property of idnovate.com, innovación y desarrollo SCP
 *
 * Permission to use, copy, modify, and/or distribute this software for any
 * purpose with or without fee is hereby granted, provided that the above
 * copyright notice and this permission notice appear in all copies.
 *
 * THE SOFTWARE IS PROVIDED "AS IS" AND THE AUTHOR DISCLAIMS ALL WARRANTIES WITH
 * REGARD TO THIS SOFTWARE INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY
 * AND FITNESS. IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY SPECIAL, DIRECT,
 * INDIRECT, OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM
 * LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR
 * OTHER TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
 * PERFORMANCE OF THIS SOFTWARE.
 *
 * @author    idnovate
 * @copyright 2025 idnovate.com
 * @license   https://www.isc.org/licenses/ https://opensource.org/licenses/ISC ISC License
 *}
{if version_compare($smarty.const._PS_VERSION_,'1.6','<')}
    <div class="translatable">
        {foreach $languages as $language}
            <div class="lang_{$language.id_lang|intval}" id="popup_height_{$language.id_lang|intval}" style="display:{if $language.id_lang == $default_form_language}block{else}none{/if}; float: left;">
                {assign var="varName" value="popup_height_{$language.id_lang|intval}"}
                <input type="text" name="{$varName|escape:'html':'UTF-8'}_{$language.id_lang|intval}" id="popup_height-name_{$language.id_lang|intval}" value="{if isset($smarty.post.{$varName|escape:'html':'UTF-8'})}{$smarty.post.{$varName|escape:'html':'UTF-8'}|escape:'htmlall':'UTF-8'}{/if}" />
            </div>
        {/foreach}
    </div>
    <div class="clear"></div>
{else}
    {foreach $languages as $language}
        {if $languages|count > 1}
            <div class="translatable-field lang-{$language['id_lang']|escape:'htmlall':'UTF-8'}" style="display: {if $language['id_lang'] == $default_form_language}block{else}none{/if};">
        {/if}

        <div class="{if $languages|count > 1}col-lg-10{else}col-lg-12{/if}">
            <div class="form-inline">
                <div class="input-group">
                    <input id="popup_height"
                           type="text"
                           name="popup_height_{$language.id_lang|intval}"
                           class="fixed-width-sm"
                           value="{if isset($smarty.post.popup_height)}{$smarty.post.popup_height|intval}{elseif $object->popup_height && $object->popup_height[$language.id_lang|intval]|intval}{$object->popup_height[$language.id_lang|intval]|intval}{/if}"
                    />

                    <span class="input-group-addon">
                        {assign var="varName" value="popup_height_unit"}
                        <input type="radio"
                               id="{$varName|escape:'html':'UTF-8'}_px"
                               name="{$varName|escape:'html':'UTF-8'}_{$language.id_lang|intval}"
                               class="form-check-input"
                               value="1"
                               {if (isset($smarty.post.$varName)
                                    && $smarty.post.$varName|intval == 1)
                                || isset($object->popup_height_unit)
                                    && is_array($object->popup_height_unit)
                                    && $object->popup_height_unit[$language.id_lang] == 1}checked="checked"{/if}
                        >
                        <label style="margin-bottom: 0; margin-right: 5px" for="popup_height_unit_px"><i class="form-check-round"></i>px</label>

                        <input type="radio"
                               id="{$varName|escape:'html':'UTF-8'}_%"
                               name="{$varName|escape:'html':'UTF-8'}_{$language.id_lang|intval}"
                               class="form-check-input"
                               value="2"
                                {if (isset($smarty.post.$varName)
                                    && $smarty.post.$varName|intval == 2)
                                || isset($object->popup_height_unit)
                                    && is_array($object->popup_height_unit)
                                    && $object->popup_height_unit[$language.id_lang] == 2}checked="checked"{/if}>
                        <label style="margin-bottom: 0" for="popup_height_unit_%"><i class="form-check-round"></i>%</label>
                    </span>
                </div>
            </div>
        </div>

{*
        <div class="radio {if isset($input.class)}{$input.class}{/if}">
            {strip}
            <label>
            <input type="radio"	name="popup_height_unit_{$language.id_lang|intval}" id="{$value.id}" value="{$value.value|escape:'html':'UTF-8'}"{if $fields_value['popup_height_unit_{$language.id_lang|intval}'] == $value.value} checked="checked"{/if}/>
                {$value.label}
            </label>
            {/strip}
        </div>
        {if isset($value.p) && $value.p}<p class="help-block">{$value.p}</p>{/if}
*}

        {if $languages|count > 1}
            <div class="col-lg-2">
                <button type="button" class="btn btn-default dropdown-toggle" tabindex="-1" data-toggle="dropdown">
                    {$language['iso_code']|escape:'htmlall':'UTF-8'}
                    <span class="caret"></span>
                </button>
                <ul class="dropdown-menu">
                    {foreach $languages as $language}
                    <li><a href="javascript:hideOtherLanguage({$language['id_lang']|escape:'htmlall':'UTF-8'});" tabindex="-1">{$language['name']|escape:'htmlall':'UTF-8'}</a></li>
                    {/foreach}
                </ul>
            </div>
        </div>
        {/if}
    {/foreach}
{/if}

