<?php
/**
 * ISC License
 *
 * Copyright (c) 2025 idnovate.com
 * idnovate is a Registered Trademark & Property of idnovate.com, innovación y desarrollo SCP
 *
 * Permission to use, copy, modify, and/or distribute this software for any
 * purpose with or without fee is hereby granted, provided that the above
 * copyright notice and this permission notice appear in all copies.
 *
 * THE SOFTWARE IS PROVIDED "AS IS" AND THE AUTHOR DISCLAIMS ALL WARRANTIES WITH
 * REGARD TO THIS SOFTWARE INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY
 * AND FITNESS. IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY SPECIAL, DIRECT,
 * INDIRECT, OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM
 * LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR
 * OTHER TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
 * PERFORMANCE OF THIS SOFTWARE.
 *
 * @author    idnovate
 * @copyright 2025 idnovate.com
 * @license   https://www.isc.org/licenses/ https://opensource.org/licenses/ISC ISC License
 */
if (!defined('_PS_VERSION_')) {
    exit;
}

$query = [];

$query[] = '
    CREATE TABLE IF NOT EXISTS `' . _DB_PREFIX_ . "advancedpopup` (
        `id_advancedpopup` int unsigned NOT NULL auto_increment,
        `id_shop` int unsigned NOT NULL DEFAULT '0',
        `name` VARCHAR(150) NOT NULL,
        `date_init` DATETIME NULL DEFAULT NULL,
        `date_end` DATETIME NULL DEFAULT NULL,
        `schedule` TEXT NULL,
        `secs_to_display` int unsigned NULL,
        `secs_to_display_cart` int unsigned NULL,
        `secs_to_close` int unsigned NULL,
        `dont_display_again` tinyint(1) NOT NULL,
        `image_link_target` VARCHAR(32) NOT NULL,
        `priority` int NULL DEFAULT '0',
        `locked` tinyint(1) NOT NULL,
        `show_customer_newsletter` tinyint(1) NULL DEFAULT '0',
        `show_customer_not_newsletter` tinyint(1) NULL DEFAULT '0',
        `show_on_view_page_nbr` int NULL DEFAULT '0',
        `show_every_nbr_hours` TEXT NULL,
        `maximum_per_user` int NULL DEFAULT '0',
        `session` tinyint(1) NULL DEFAULT '0',
        `nb_products` TEXT NULL,
        `nb_products_comparator` tinyint(1) NULL DEFAULT '0',
        `back_opacity_value` decimal(10,2) NULL DEFAULT '0.00',
        `controller_exceptions` TEXT NULL,
        `groups` TEXT NULL,
        `genders` TEXT NULL,
        `customers` TEXT NULL,
        `products` TEXT NULL,
        `countries` TEXT NULL,
        `zones` TEXT NULL,
        `categories` TEXT NULL,
        `categories_selected` TEXT NULL,
        `manufacturers` TEXT NULL,
        `suppliers` TEXT NULL,
        `cms` TEXT NULL,
        `languages` TEXT NULL,
        `attributes` TEXT NULL,
        `features` TEXT NULL,
        `active` tinyint(1) NOT NULL DEFAULT '0',
        `display_on_load` tinyint(1) NOT NULL,
        `display_after_cart` tinyint(1) NOT NULL,
        `display_on_exit` tinyint(1) NOT NULL,
        `display_on_click` tinyint(1) NOT NULL,
        `display_on_click_selector` VARCHAR(150) NULL,
        `display_inactive` tinyint(1) NOT NULL,
        `secs_to_display_inactive` int unsigned NULL,
        `display_on_sticky` tinyint(1) NOT NULL,
        `close_on_background` tinyint(1) NOT NULL,
        `blur_background` tinyint(1) NOT NULL,
        `display_backdrop` tinyint(1) NOT NULL,
        `color_background` varchar(32) NULL,
        `open_effect` VARCHAR(32),
        `position` INT(11) NOT NULL,
        `cart_amount` tinyint(1) NOT NULL,
        `cart_amount_from` decimal(20,2),
        `cart_amount_to` decimal(20,2),
        `display_mobile` tinyint(1) NOT NULL,
        `display_tablet` tinyint(1) NOT NULL,
        `display_desktop` tinyint(1) NOT NULL,
        `display_ip_string` TEXT NULL,
        `product_specific_price` tinyint(1) NOT NULL,
        `product_stock` tinyint(1) NOT NULL,
        `product_stock_from` INT(10) NULL,
        `product_stock_to` INT(10) NULL,
        `product_price` tinyint(1) NOT NULL,
        `product_price_from` decimal(17,2) NOT NULL DEFAULT '0.00',
        `product_price_to` decimal(17,2) NOT NULL DEFAULT '0.00',
        `product_oos` tinyint(1) NOT NULL,
        `product_oos_value` INT(10) NULL,
        `sticky_display_close` tinyint NOT NULL,
        `sticky_position` int NOT NULL,
        `sticky_rotation` int NOT NULL,
        `date_add` DATETIME NOT NULL,
        `date_upd` DATETIME NULL DEFAULT NULL,
    PRIMARY KEY (`id_advancedpopup`),
    KEY `id_advancedpopup` (`id_advancedpopup`)
    ) ENGINE=" . _MYSQL_ENGINE_ . ' DEFAULT CHARSET=utf8;
    ';

$query[] = '
    CREATE TABLE IF NOT EXISTS `' . _DB_PREFIX_ . 'advancedpopup_lang` (
        `id_advancedpopup` int unsigned NOT NULL,
        `id_lang` int unsigned NOT NULL,
        `css_class` VARCHAR(150) NULL,
        `css` TEXT NULL DEFAULT NULL,
        `js` TEXT NULL DEFAULT NULL,
        `content` TEXT NULL DEFAULT NULL,
        `image_background` VARCHAR(150) NULL,
        `image` VARCHAR(150) NULL DEFAULT NULL,
        `image_link` VARCHAR(250) NULL,
        `popup_height` TEXT NULL,
        `popup_height_unit` int unsigned NULL,
        `popup_width` TEXT NULL,
        `popup_width_unit` int unsigned NULL,
        `popup_padding` int NULL,
        `responsive_min` int NULL,
        `responsive_max` int NULL,
        `display_url_string` VARCHAR(150) NULL,
        `display_referrer_string` VARCHAR(150) NULL,
        `sticky_content` text NULL,
    PRIMARY KEY (`id_advancedpopup`, `id_lang`),
    KEY `id_advancedpopup` (`id_advancedpopup`)
    ) ENGINE=' . _MYSQL_ENGINE_ . ' DEFAULT CHARSET=utf8;
    ';

foreach ($query as $query) {
    Db::getInstance()->execute($query);
}

return true;
