<?php
/**
 * ISC License
 *
 * Copyright (c) 2025 idnovate.com
 * idnovate is a Registered Trademark & Property of idnovate.com, innovación y desarrollo SCP
 *
 * Permission to use, copy, modify, and/or distribute this software for any
 * purpose with or without fee is hereby granted, provided that the above
 * copyright notice and this permission notice appear in all copies.
 *
 * THE SOFTWARE IS PROVIDED "AS IS" AND THE AUTHOR DISCLAIMS ALL WARRANTIES WITH
 * REGARD TO THIS SOFTWARE INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY
 * AND FITNESS. IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY SPECIAL, DIRECT,
 * INDIRECT, OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM
 * LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR
 * OTHER TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
 * PERFORMANCE OF THIS SOFTWARE.
 *
 * @author    idnovate
 * @copyright 2025 idnovate.com
 * @license   https://www.isc.org/licenses/ https://opensource.org/licenses/ISC ISC License
 */
if (!defined('_PS_VERSION_')) {
    exit;
}

function upgrade_module_1_1_9()
{
    $query = 'ALTER TABLE `' . _DB_PREFIX_ . "advancedpopup`
        CHANGE `controller_exceptions` `controller_exceptions` text COLLATE 'utf8_general_ci' NOT NULL AFTER `back_opacity_value`,
        CHANGE `groups` `groups` text COLLATE 'utf8_general_ci' NOT NULL AFTER `controller_exceptions`,
        CHANGE `customers` `customers` text COLLATE 'utf8_general_ci' NOT NULL AFTER `groups`,
        CHANGE `products` `products` text COLLATE 'utf8_general_ci' NOT NULL AFTER `customers`,
        CHANGE `countries` `countries` text COLLATE 'utf8_general_ci' NOT NULL AFTER `products`,
        CHANGE `zones` `zones` text COLLATE 'utf8_general_ci' NOT NULL AFTER `countries`,
        CHANGE `categories` `categories` text COLLATE 'utf8_general_ci' NOT NULL AFTER `zones`,
        CHANGE `manufacturers` `manufacturers` text COLLATE 'utf8_general_ci' NOT NULL AFTER `categories_selected`,
        CHANGE `suppliers` `suppliers` text COLLATE 'utf8_general_ci' NOT NULL AFTER `manufacturers`,
        CHANGE `cms` `cms` text COLLATE 'utf8_general_ci' NOT NULL AFTER `suppliers`,
        CHANGE `languages` `languages` text COLLATE 'utf8_general_ci' NOT NULL AFTER `cms`,
        CHANGE `display_ip_string` `display_ip_string` text COLLATE 'utf8_general_ci' NOT NULL AFTER `display_desktop`;";

    Db::getInstance()->execute($query);

    $query = 'ALTER TABLE `' . _DB_PREFIX_ . "advancedpopup_lang`
        CHANGE `responsive_min` `responsive_min` int(11) NOT NULL AFTER `popup_padding`,
        CHANGE `responsive_max` `responsive_max` int(11) NOT NULL AFTER `responsive_min`,
        CHANGE `display_url_string` `display_url_string` varchar(150) COLLATE 'utf8_general_ci' NOT NULL AFTER `responsive_max`,
        CHANGE `display_referrer_string` `display_referrer_string` varchar(150) COLLATE 'utf8_general_ci' NOT NULL AFTER `display_url_string`";

    Db::getInstance()->execute($query);

    return true;
}
