{**
 * ISC License
 *
 * Copyright (c) 2025 idnovate.com
 * idnovate is a Registered Trademark & Property of idnovate.com, innovación y desarrollo SCP
 *
 * Permission to use, copy, modify, and/or distribute this software for any
 * purpose with or without fee is hereby granted, provided that the above
 * copyright notice and this permission notice appear in all copies.
 *
 * THE SOFTWARE IS PROVIDED "AS IS" AND THE AUTHOR DISCLAIMS ALL WARRANTIES WITH
 * REGARD TO THIS SOFTWARE INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY
 * AND FITNESS. IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY SPECIAL, DIRECT,
 * INDIRECT, OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM
 * LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR
 * OTHER TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
 * PERFORMANCE OF THIS SOFTWARE.
 *
 * @author    idnovate
 * @copyright 2025 idnovate.com
 * @license   https://www.isc.org/licenses/ https://opensource.org/licenses/ISC ISC License
 *}
<div style="overflow: hidden;">
    {if version_compare($smarty.const._PS_VERSION_,'1.6','<')}
        <div class="translatable">
            {foreach $languages as $language}
                <div class="lang_{$language.id_lang|intval}" id="{$image_field|escape:'html':'UTF-8'}_{$language.id_lang|intval}" style="display:{if $language.id_lang == $default_form_language}block{else}none{/if}; float: left;">
                    {assign var="varName" value="image_{$language.id_lang|intval}"}
                    <input type="file" name="image_{$language.id_lang|intval}" id="{$image_field|escape:'html':'UTF-8'}-name_{$language.id_lang|intval}" value="{if isset($smarty.post.{$varName|escape:'html':'UTF-8'})}{$smarty.post.{$varName|escape:'html':'UTF-8'}|escape:'htmlall':'UTF-8'}{/if}" />
                </div>
            {/foreach}
        </div>
        <div class="clear"></div>
    {else}
        {foreach $languages as $language}
            {if $languages|count > 1}
            <div class="translatable-field lang-{$language['id_lang']|escape:'htmlall':'UTF-8'}" style="display: {if $language['id_lang'] == $default_form_language}block{else}none{/if};">
            {/if}
                <div class="col-lg-10">
                    <div class="form-group" style="margin-bottom: 0;">
                        <input id="{$image_field|escape:'html':'UTF-8'}_{$language.id_lang|intval}" type="file" name="{$image_field|escape:'html':'UTF-8'}_{$language.id_lang|intval}"" class="hide" />
                        <div class="dummyfile input-group">
                            <span class="input-group-addon"><i class="icon-file"></i></span>
                            <input id="{$image_field|escape:'html':'UTF-8'}-name_{$language.id_lang|intval}" type="text" readonly="">
                            <span class="input-group-btn">
                                <button id="{$image_field|escape:'html':'UTF-8'}-selectbutton_{$language.id_lang|intval}" type="button" name="submitAddAttachments" class="btn btn-default">
                                    <i class="icon-folder-open"></i> {if isset($multiple) && $multiple}{l s='Add files' mod='advancedpopupcreator'}{else}{l s='Add file' mod='advancedpopupcreator'}{/if}
                                </button>
                            </span>
                        </div>
                    </div>
                </div>
                <script type="text/javascript" style="display: none">
                    $(document).ready(function(){
                        $('#{$image_field|escape:'html':'UTF-8'}-selectbutton_{$language.id_lang|intval}').click(function(e) {
                            $('#{$image_field|escape:'html':'UTF-8'}_{$language.id_lang|intval}').trigger('click');
                        });

                        $('#{$image_field|escape:'html':'UTF-8'}-name_{$language.id_lang|intval}').click(function(e) {
                            $('#{$image_field|escape:'html':'UTF-8'}_{$language.id_lang|intval}').trigger('click');
                        });

                        $('#{$image_field|escape:'html':'UTF-8'}-name_{$language.id_lang|intval}').on('dragenter', function(e) {
                            e.stopPropagation();
                            e.preventDefault();
                        });

                        $('#{$image_field|escape:'html':'UTF-8'}-name_{$language.id_lang|intval}').on('dragover', function(e) {
                            e.stopPropagation();
                            e.preventDefault();
                        });

                        $('#{$image_field|escape:'html':'UTF-8'}-name_{$language.id_lang|intval}').on('drop', function(e) {
                            e.preventDefault();
                            var files = e.originalEvent.dataTransfer.files;
                            $('#{$image_field|escape:'html':'UTF-8'}_{$language.id_lang|intval}')[0].files = files;
                            $(this).val(files[0].name);
                        });

                        $('#{$image_field|escape:'html':'UTF-8'}_{$language.id_lang|intval}').change(function(e) {
                            if ($(this)[0].files !== undefined)
                            {
                                var files = $(this)[0].files;
                                var name  = '';

                                $.each(files, function(index, value) {
                                    name += value.name+', ';
                                });

                                $('#{$image_field|escape:'html':'UTF-8'}-name_{$language.id_lang|intval}').val(name.slice(0, -2));
                            }
                            else // Internet Explorer 9 Compatibility
                            {
                                var name = $(this).val().split(/[\\/]/);
                                $('#{$image_field|escape:'html':'UTF-8'}-name_{$language.id_lang|intval}').val(name[name.length-1]);
                            }
                        });
                    });
                </script>
            {if $languages|count > 1}
            <div class="col-lg-2">
                <button type="button" class="btn btn-default dropdown-toggle" tabindex="-1" data-toggle="dropdown">
                    {$language['iso_code']|escape:'htmlall':'UTF-8'}
                    <span class="caret"></span>
                </button>
                <ul class="dropdown-menu">
                    {foreach $languages as $language}
                    <li><a href="javascript:hideOtherLanguage({$language['id_lang']|escape:'htmlall':'UTF-8'});" tabindex="-1">{$language['name']|escape:'htmlall':'UTF-8'}</a></li>
                    {/foreach}
                </ul>
            </div>
        </div>
        {/if}
        {/foreach}
    {/if}
</div>
