{**
 * ISC License
 *
 * Copyright (c) 2025 idnovate.com
 * idnovate is a Registered Trademark & Property of idnovate.com, innovación y desarrollo SCP
 *
 * Permission to use, copy, modify, and/or distribute this software for any
 * purpose with or without fee is hereby granted, provided that the above
 * copyright notice and this permission notice appear in all copies.
 *
 * THE SOFTWARE IS PROVIDED "AS IS" AND THE AUTHOR DISCLAIMS ALL WARRANTIES WITH
 * REGARD TO THIS SOFTWARE INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY
 * AND FITNESS. IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY SPECIAL, DIRECT,
 * INDIRECT, OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM
 * LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR
 * OTHER TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
 * PERFORMANCE OF THIS SOFTWARE.
 *
 * @author    idnovate
 * @copyright 2025 idnovate.com
 * @license   https://www.isc.org/licenses/ https://opensource.org/licenses/ISC ISC License
 *}
<!-- Modal -->
{* Position *}
{if $position|intval == 1}
    {assign var="modal_class" value="modal-dialog-top-left"}
{elseif $position|intval == 2}
    {assign var="modal_class" value="modal-dialog-top-middle"}
{elseif $position|intval == 3}
    {assign var="modal_class" value="modal-dialog-top-right"}
{elseif $position|intval == 4}
    {assign var="modal_class" value="modal-dialog-middle-left"}
{elseif $position|intval == 5}
    {assign var="modal_class" value="modal-dialog-middle"}
{elseif $position|intval == 6}
    {assign var="modal_class" value="modal-dialog-middle-right"}
{elseif $position|intval == 7}
    {assign var="modal_class" value="modal-dialog-bottom-left"}
{elseif $position|intval == 8}
    {assign var="modal_class" value="modal-dialog-bottom-middle"}
{else}
    {assign var="modal_class" value="modal-dialog-bottom-right"}
{/if}

{* Backdrop *}
{if $lsDisplayBackdrop && $lbCloseOnBackground}
    {assign var="backdrop" value="true"}
{elseif $lsDisplayBackdrop && !$lbCloseOnBackground}
    {assign var="backdrop" value="static"}
{else}
    {assign var="backdrop" value="false"}
{/if}

{assign var="keyboard" value="true"}

<!-- Sticky -->
{* Position *}
{if $sticky_position|intval == 1}
    {assign var="sticky_class" value="sticky-block-top-left"}
{elseif $sticky_position|intval == 2}
    {assign var="sticky_class" value="sticky-block-top-middle"}
{elseif $sticky_position|intval == 3}
    {assign var="sticky_class" value="sticky-block-top-right"}
{elseif $sticky_position|intval == 4}
    {assign var="sticky_class" value="sticky-block-middle-left"}
{elseif $sticky_position|intval == 6}
    {assign var="sticky_class" value="sticky-block-middle-right"}
{elseif $sticky_position|intval == 7}
    {assign var="sticky_class" value="sticky-block-bottom-left"}
{elseif $sticky_position|intval == 8}
    {assign var="sticky_class" value="sticky-block-bottom-middle"}
{else}
    {assign var="sticky_class" value="sticky-block-bottom-right"}
{/if}

<style>
    #apcModal_{$popupId|intval} .modal-dialog {
        max-width: 98%;
    }

    #apcModal_{$popupId|intval} .modal-content {
        height: 100%;
    }

    /* Top left */
    #apcModal_{$popupId|intval} .modal-dialog-top-left {
        position: fixed;
        top: 20px;
        left: 20px;
        margin: 0;
    }

    /* Top center */
    #apcModal_{$popupId|intval} .modal-dialog-top-middle {
        position: fixed;
        top: 20px;
        left: 50%;
        transform: translateX(-50%);
        margin: 0;
    }

    /* Top right */
    #apcModal_{$popupId|intval} .modal-dialog-top-right {
        position: fixed;
        top: 20px;
        right: 20px;
        margin: 0;
    }

    /* Middle left */
    #apcModal_{$popupId|intval} .modal-dialog-middle-left {
        position: fixed;
        top: 50%;
        left: 20px;
        transform: translateY(-50%);
        margin: 0;
    }

    /* Middle center (default Bootstrap positioning) */
    #apcModal_{$popupId|intval} .modal-dialog-middle {
        position: fixed;
        top: 50%;
        left: 50%;
        transform: translate(-50%, -50%);
        margin: 0;
    }

    /* Middle right */
    #apcModal_{$popupId|intval} .modal-dialog-middle-right {
        position: fixed;
        top: 50%;
        right: 20px;
        transform: translateY(-50%);
        margin: 0;
    }

    /* Bottom left */
    #apcModal_{$popupId|intval} .modal-dialog-bottom-left {
        position: fixed;
        bottom: 20px;
        left: 20px;
        margin: 0;
    }

    /* Bottom center */
    #apcModal_{$popupId|intval} .modal-dialog-bottom-middle {
        position: fixed;
        bottom: 20px;
        left: 50%;
        transform: translateX(-50%);
        margin: 0;
    }

    /* Bottom right */
    #apcModal_{$popupId|intval} .modal-dialog-bottom-right {
        position: fixed;
        bottom: 20px;
        right: 20px;
        margin: 0;
    }

    {if $lsPadding}
    #apcModal_{$popupId|intval} .modal-content {
        padding: {$lsPadding|escape:'html':'UTF-8'}px;
    }
    {/if}

    {if ($colorBackground)}
    #apcModal_{$popupId|intval} .modal-content {
        background-color: {$colorBackground|escape:'html':'UTF-8'} !important;
    }
    {/if}

    {if isset($imageBackground) && $imageBackground}
    #apcModal_{$popupId|intval} .modal-content {
        background-image: url({$imageBackground|escape:'html':'UTF-8'}) !important;
        background-size: cover !important;
        background-repeat: no-repeat !important;
        background-position: center center !important;
    }
    {/if}

    .clock_container {
        position: absolute;
        top: -15px;
        right: -15px;
        background: transparent;
        border: none;
        width: 30px;
        height: 30px;
        aspect-ratio: 1 / 1.2;
        color: white;
    }

    .timer {
        width: 100%;
        aspect-ratio: 1 / 1;
        /*background:red;*/
        align-items: center;

    }

    .donat {
        aspect-ratio: 1 / 1;
        border-radius: 50%;
        border: 2px solid transparent;
    }

    .inner-circle {
        position: relative;
        width: 100%;
        z-index: 1;
        background: linear-gradient(white, white) content-box no-repeat, conic-gradient(red var(--inner_percent_deg, 0%), 0, grey) border-box;
        display: flex;
        justify-content: center;
    }

    #apcModal_{$popupId|intval} .btn-close {
        padding: .3em .3em;
    }

    .sticky-block {
        position: fixed;
        margin: 0;
        z-index: 1050;
    }

    /* Top left */
    #stickyBlock_{$popupId|intval}.sticky-block-top-left {
        top: 5px;
        left: 5px;
    }

    #stickyBlock_{$popupId|intval}.sticky-block-top-left.rotate-90 button {
        transform: translateY(-100%) rotate(90deg);
        transform-origin: left bottom;
    }

    #stickyBlock_{$popupId|intval}.sticky-block-top-left.rotate-270 button {
        transform: rotate(270deg);
        transform-origin: left top;
    }

    /* Top center */
    #stickyBlock_{$popupId|intval}.sticky-block-top-middle {
        position: fixed;
        top: 5px;
        left: 50%;
        transform: translateX(-50%);
        margin: 0;
    }

    /* Top right */
    .sticky-block-top-right {
        position: fixed;
        top: 5px;
        right: 5px;
        margin: 0;
    }

    .sticky-block-top-right.rotate-90 button {
        transform: rotate(90deg);
        transform-origin: left top;
    }

    .sticky-block-top-right.rotate-270 button {
        transform: translateY(-100%) rotate(270deg);
        transform-origin: bottom right;
    }

    /* Middle left */
    .sticky-block-middle-left {
        position: fixed;
        top: 50%;
        left: 0px;
        transform: translateY(-50%);
    }

    .sticky-block-middle-left.rotate-90 button {
        transform: rotate(90deg);
        transform-origin: center bottom;
    }

    .sticky-block-middle-left.rotate-270 button {
        transform: translateX(-50%) rotate(270deg);
        transform-origin: center top;
    }

    /* Middle right */
    #stickyBlock_{$popupId|intval}.sticky-block-middle-right {
        position: fixed;
        top: 50%;
        right: 5px;
        transform: translateY(-50%);
        margin: 0;
    }

    .sticky-block-middle-right.rotate-90 button {
        transform: translateX(-50%) rotate(90deg);
        transform-origin: center top;
    }

    .sticky-block-middle-right.rotate-270 button {
        transform: translateX(-50%) rotate(270deg);
        transform-origin: center bottom;
    }

    /* Bottom left */
    #stickyBlock_{$popupId|intval}.sticky-block-bottom-left {
        position: fixed;
        bottom: 5px;
        left: 5px;
        margin: 0;
    }

    #stickyBlock_{$popupId|intval}.sticky-block-bottom-left.rotate-90 button {
        transform: rotate(90deg);
        transform-origin: left bottom;
    }

    #stickyBlock_{$popupId|intval}.sticky-block-bottom-left.rotate-270 button {
        transform: translateY(100%) rotate(270deg);
        transform-origin: left top;
    }

    /* Bottom center */
    #stickyBlock_{$popupId|intval}.sticky-block-bottom-middle {
        position: fixed;
        bottom: 5px;
        left: 50%;
        transform: translateX(-50%);
        margin: 0;
    }

    /* Bottom right */
    #stickyBlock_{$popupId|intval}.sticky-block-bottom-right {
        bottom: 5px;
        right: 5px;
    }

    .sticky-block-bottom-right.rotate-90 button {
        transform: translateY(100%) rotate(90deg);
        transform-origin: right top;
    }

    .sticky-block-bottom-right.rotate-270 button {
        transform: rotate(270deg);
        transform-origin: bottom right;
    }

    {if isset($lsPopupCss) && $lsPopupCss}
        {$lsPopupCss nofilter}
    {/if}
</style>

<div
        data-easein="{$openEffect|escape:'html':'UTF-8'}"
        class="modal apc_modal {$lsCssClass|escape:'html':'UTF-8'}"
        data-popup-id="{$popupId|intval}"
        id="apcModal_{$popupId|intval}"
        tabindex="-1"
        aria-labelledby="exampleModalLabel"
        aria-hidden="true"
        data-blur-background="{$lsBlurBackground|escape:'html':'UTF-8'}"
        data-bs-backdrop="{$backdrop|escape:'html':'UTF-8'}"
        data-bs-keyboard="{$keyboard|escape:'html':'UTF-8'}"
        data-secs-close="{$lfSecsToClose|intval}"
        data-secs-display="{$lfSecsToDisplay|intval}"
        data-opacity="{$lsBackOpacityValue|escape:'html':'UTF-8'}"
        data-locked="{$lbLocked|intval}"
        data-close-on-background="{$lbCloseOnBackground|intval}"
        data-sticky-display-close="{$sticky_display_close|intval}"
>
    <div class="modal-dialog {$modal_class|escape:'html':'UTF-8'}" style="width: {if $lsWidth} {$lsWidth|escape:'html':'UTF-8'}{$lsWidthUnit|escape:'html':'UTF-8'}{else}auto{/if}; height: {if $lsHeight} {$lsHeight|escape:'html':'UTF-8'}{$lsHeightUnit|escape:'html':'UTF-8'}{else}auto{/if};">
        <div class="modal-content">
            <div class="modal-body p-0">
                {if $lsContent}
                    {$lsContent nofilter}
                {/if}
            </div>

            <div class="clock_container">
                <div class="timer">
                    <div class="donat inner-circle">
                        <button type="button" class="btn-close m-0" id="closeButton" data-bs-dismiss="modal" data-dismiss="modal" aria-label="Close"></button>
                    </div>
                </div>
            </div>

            {if ($dontDisplayAgain)}
                <div class="modal-footer">
                    <div id="apc_modal-{$popupId|intval}-dont-show-again" class="dont-show-again">
                        <input type="checkbox" onclick="dontDisplayAgain({$popupId|intval})"> <a onclick="dontDisplayAgain({$popupId|intval})">{l s='Don\'t show this again' mod='advancedpopupcreator'}</a>
                    </div>
                </div>
            {/if}
        </div>
    </div>
</div>

<!-- Sticky Block -->
<div id="stickyBlock_{$popupId|intval}" class="sticky-block {$sticky_class|escape:'html':'UTF-8'} {if $sticky_rotation|intval == 2}rotate-90{elseif $sticky_rotation|intval == 3}rotate-270{/if}" {if !$display_on_sticky|intval}style="visibility: hidden"{/if}onclick="displayPopup({$popupId|intval})">
    <button class="btn btn-primary btn-sm">{$sticky_content nofilter}</button>
</div>

<script>
    // Function to process buttons and apply transformations
    function applyTransform(selector, transformType, direction = 1) {
        const buttons = document.querySelectorAll(selector);
        buttons.forEach(button => {
            const buttonWidth = button.offsetWidth;
            const value = direction * buttonWidth;
            button.style.transform = transformType + '(' + value + 'px)';
        });
    }

    // Apply transformations
    applyTransform('.sticky-block-top-left.rotate-270', 'translateY', 1);
    applyTransform('.sticky-block-top-right.rotate-90', 'translateX', 1);
    applyTransform('.sticky-block-middle-right.rotate-90', 'translateX', 1);
    applyTransform('.sticky-block-middle-right.rotate-270', 'translateX', 1);
    applyTransform('.sticky-block-bottom-left.rotate-90', 'translateY', -1);
    applyTransform('.sticky-block-bottom-right.rotate-270', 'translateY', -1);
</script>

