<?php
/**
 * 2013 - 2023 Payplug SAS
 *
 * NOTICE OF LICENSE
 *
 * This source file is subject to the Open Software License (OSL 3.0).
 * It is available through the world-wide-web at this URL:
 * https://opensource.org/licenses/osl-3.0.php
 * If you are unable to obtain it through the world-wide-web, please send an email
 * to contact@payplug.com so we can send you a copy immediately.
 *
 * DISCLAIMER
 *
 * Do not edit or add to this file if you wish to upgrade PayPlug module to newer
 * versions in the future.
 *
 * @author    Payplug SAS
 * @copyright 2013 - 2023 Payplug SAS
 * @license   https://opensource.org/licenses/osl-3.0.php  Open Software License (OSL 3.0)
 *  International Registered Trademark & Property of Payplug SAS
 */

namespace PayPlug\src\application\adapter;

use Country;
use PayPlug\src\interfaces\CountryInterface;

class CountryAdapter implements CountryInterface
{
    public static function factory()
    {
        return new self();
    }

    public function get($idCountry = false)
    {
        if (!is_int($idCountry)) {
            $idCountry = false;
        }

        return new Country($idCountry);
    }

    public function getByIso($idCurrency)
    {
        return Country::getByIso($idCurrency);
    }

    public function getCountry($idCountry)
    {
        return new Country($idCountry);
    }

    public function getNameById($param1, $param2)
    {
        return Country::getNameById($param1, $param2);
    }
}
