<?php

if (!defined('_PS_VERSION_'))
	exit;

class NewProducts extends Module
{
	private $_html = '';
	private $_postErrors = array();

	function __construct()
	{
		$this->name = 'newproducts';
		$this->tab = 'front_office_features';
		$this->version = '0.9';
		$this->author = 'PrestaShop';
		$this->need_instance = 0;

		parent::__construct();

		$this->displayName = $this->l('Slider of new products on the homepage');
		$this->description = $this->l('Displays a slider of new products on homepage');
	}

	function install()
	{
		if (!parent::install() || !$this->registerHook('displayHome') || !$this->registerHook('header'))
			return false;
		return true;
	}


	public function hookDisplayHeader($params)
	{
		$this->hookHeader($params);
	}

	public function hookHeader($params)
	{
		$this->context->controller->addCss($this->_path.'newproducts.css', 'all');
	}

	public function hookDisplayHome($params)
	{		
		$newProducts = Product::getNewProducts((int)($params['cookie']->id_lang), 0,10);
		if (!$newProducts && !Configuration::get('PS_BLOCK_NEWPRODUCTS_DISPLAY'))
			return;

		$this->smarty->assign(array(
			'products' => $newProducts,
			'homeSize' => Image::getSize('home_default'),
		));

		return $this->display(__FILE__, 'newproducts.tpl');
	}
}
