# ReCaptcha #

Ce module vous permet d'ajouter un ReCaptcha Google sur vos formulaires d'inscription et de contact afin de vous protéger des spams.

## Installation ##

1. Après l'installation standard, vous devez définir vos clés publiques et privées de Google ReCaptcha. Pour ce faire, vous devez créer un compte et inscrire votre site sur la page de [configuration Google ReCaptcha](https://www.google.com/recaptcha/admin#whyrecaptcha). Il faut un certain temps pour que vos clés soient activées par Google, le module ne sera pas activé jusque-là.

2. Dans la configuration du module, vous pouvez choisir si vous voulez que le recaptcha s'affiche sur vos pages d'inscription et de contact.

3.
    1. Pour Prestashop 1.4, 1.5 et 1.6
	- ajouter la ligne suivante à l'endroit où vous voulez voir apparaître le captcha, dans */themes/votre-theme/contact-form.tpl*
	```html
	{if isset($HOOK_CONTACT_FORM_BOTTOM)}{$HOOK_CONTACT_FORM_BOTTOM}{/if}
	```

    2. Pour Prestashop 1.7
	- ajouter la ligne suivante à l'endroit où vous voulez voir apparaître le captcha, dans */themes/your_theme/modules/contactform/views/templates/widget/contactform.tpl*
	```html
	{if isset($HOOK_CONTACT_FORM_BOTTOM)}{$HOOK_CONTACT_FORM_BOTTOM nofilter}{/if}
	```
	- ajouter la ligne suivante à l'endroit où vous voulez voir apparaître le captcha, dans */themes/your_theme/templates/customer/_partials/customer-form.tpl*
	```html
	{hook h='displayCustomerAccountForm'}
	```
	- copier le fichier */modules/recaptcha/override/modules/contactform/contactform.php* vers */override/modules/contactform/contactform.php*. Créez le chemin si nécessaire. Si le fichier existe, un développeur devra fusionner le code.


4. Si vous utiliser la gestion du cache de Prestashop :
	- Rendez-vous sur la page Administration > Paramètres Avancés > Performances
	- Sélectionnez "Forcer la compilation à chaque appel"
	- Mettez "Cache" à "Non"
	- Enregistrez
	- Videz votre cache navigateur ou ouvrez une session de navigation privée
	- Rafraîchissez la page de contact afin de re-générer le cache
	- Vous pouvez ensuite rétablir la configuration précédente