<?php
/*
* 2007-2012 PrestaShop
*
* NOTICE OF LICENSE
*
* This source file is subject to the Academic Free License (AFL 3.0)
* that is bundled with this package in the file LICENSE.txt.
* It is also available through the world-wide-web at this URL:
* http://opensource.org/licenses/afl-3.0.php
* If you did not receive a copy of the license and are unable to
* obtain it through the world-wide-web, please send an email
* to license@prestashop.com so we can send you a copy immediately.
*
* DISCLAIMER
*
* Do not edit or add to this file if you wish to upgrade PrestaShop to newer
* versions in the future. If you wish to customize PrestaShop for your
* needs please refer to http://www.prestashop.com for more information.
*
*  @author PrestaShop SA <contact@prestashop.com>
*  @copyright  2007-2012 PrestaShop SA
*  @version  Release: $Revision: 7048 $
*  @license    http://opensource.org/licenses/afl-3.0.php  Academic Free License (AFL 3.0)
*  International Registered Trademark & Property of PrestaShop SA
*/

if (!defined('_PS_VERSION_'))
	exit;

class HomeManufacturer extends Module
{
    public function __construct()
    {
        $this->name = 'homemanufacturer';
        $this->tab = 'front_office_features';
        $this->version = 1.0;
		$this->author = 'PrestaShop';
		$this->need_instance = 0;

        parent::__construct();

		$this->displayName = $this->l('Brands slider on homepage');
        $this->description = $this->l('Displays a slider of brands on your homepage');
    }

	public function install()
	{

        return parent::install() && $this->registerHook('displayHome') && $this->registerHook('header');
    }

	public function hookDisplayHome($params)
	{
		$this->smarty->assign(array(
			'manufacturers' => Manufacturer::getManufacturers(),
		));
		return $this->display(__FILE__, 'homemanufacturer.tpl');
	}



	public function hookHeader($params)
	{

	}
}
