/**
 * ISC License
 *
 * Copyright (c) 2025 idnovate.com
 * idnovate is a Registered Trademark & Property of idnovate.com, innovación y desarrollo SCP
 *
 * Permission to use, copy, modify, and/or distribute this software for any
 * purpose with or without fee is hereby granted, provided that the above
 * copyright notice and this permission notice appear in all copies.
 *
 * THE SOFTWARE IS PROVIDED "AS IS" AND THE AUTHOR DISCLAIMS ALL WARRANTIES WITH
 * REGARD TO THIS SOFTWARE INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY
 * AND FITNESS. IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY SPECIAL, DIRECT,
 * INDIRECT, OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM
 * LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR
 * OTHER TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
 * PERFORMANCE OF THIS SOFTWARE.
 *
 * @author    idnovate
 * @copyright 2025 idnovate.com
 * @license   https://www.isc.org/licenses/ https://opensource.org/licenses/ISC ISC License
 */

$('.textarea-autosize.apc_tiny').removeClass('textarea-autosize');

$(document).ready(function(){
    if (typeof(tinySetup) != "undefined") {
        /*if (typeof(module_dir) == "undefined") {
            var module_dir = '/modules/';
        }*/

        tinySetup({
            editor_selector: "apc_tiny",
            valid_children: "+body[style|script|iframe|section|link],pre[iframe|section|script|div|p|br|span|img|style|h1|h2|h3|h4|h5],*[*]",
            forced_root_block: '',
            external_plugins: {
                "filemanager": ad + "/filemanager/plugin.min.js",
                'codemirror': module_dir + "advancedpopupcreator/lib/tiny_mce/codemirror/plugin.min.js"
            },
            codemirror: {
                indentOnInit: true,
                path: '../../CodeMirror',
            }
        });
    }

    //Apply CodeMirror in CSS field
    $('textarea[name^="css"]').each(function() {
        var myCodeMirror = CodeMirror.fromTextArea($(this)[0], {
            mode: "css"
        });

		myCodeMirror.setSize(700, 225);
    });

    /* Filter switches */
    // Hide all multiselect without selected values
    // If multiselect has selected values, don't hide it
    $("[class^='switch_']").not('div').each(function () {
        let elementClass = $(this).attr('class').split(" ").filter(function(n) {
          if(/switch/.test(n)) return n;
        });
        var that = this;
        elementClass.forEach(function(element) {
            if ($(that).is('input')) {
                if ($(that).val().length > 0) {
                    $('#'+element+'_on').attr('checked', true);
                    $(that).closest('.margin-group').show();
                };
            } else if ($(that).is('select')) {
                if (!$(that).hasClass('selectedSwap')) {
                    return;
                }
                if ($(that).find('option').length > 0) {
                    $('#'+element+'_on').attr('checked', true);
                    $(that).closest('.margin-group').show().find('*').show();
                }
            }
        });
    });

    if ($('[name^=display_url_string_]').filter(function() { return $(this).val(); }).length > 0) {
        $('#display_url_on').attr('checked', true);
    }

    if ($('[name^=display_referrer_string_]').filter(function() { return $(this).val(); }).length > 0) {
        $('#display_referrer_on').attr('checked', true);
    }

    if ($('[name^=display_ip_string]').filter(function() { return $(this).val(); }).length > 0) {
        $('#display_ip_on').attr('checked', true);
    }

    // Display/hide values when switch changes
    $('[name^=switch_], [name=display_on_load], [name=display_after_cart], [name=display_on_click], [name=cart_amount], [name=product_stock], [name=display_url_string], [name=display_referrer_string], [name=display_ip_string]').change(function() {
        toggleFilters();
    });

    toggleFilters();
});

function toggleFilters() {
    $('[name^=switch_]:checked, [name=display_on_load]:checked, [name=display_after_cart]:checked, [name=display_on_click]:checked, [name=cart_amount]:checked, [name=product_stock]:checked, [name=display_url_string]:checked, [name=display_referrer_string]:checked, [name=display_ip_string]:checked').each(function () {
        var fieldName = $(this).attr('name');

        if (fieldName === 'switch_categories_selected') {
            if ($(this).val() === "0") {
                $(this).parents().eq(0).next().next().hide().next().hide().next().next().hide();
            } else {
                $(this).parents().eq(0).next().next().show().next().show().next().next().show();
            }
        } else if (fieldName === 'cart_amount' || fieldName === 'product_stock') {
            if ($(this).val() === "0") {
				$(this).parents().eq(0).next().next().hide().next().hide().next().next().hide().next().hide();
            } else {
				$(this).parents().eq(0).next().next().show().next().show().next().next().show().next().show();
            }
        } else {
            if ($(this).val() === "0") {
                $(this).parents().eq(0).next().next().hide().next().hide();
            } else {
                $(this).parents().eq(0).next().next().show().next().show();
            }
        }
    });
}

// If multiselect has selected values, display it on load
if ($('#controller_exceptions\\[\\]').find('> option:selected').length > 0) {
    $('#switch_controller_exceptions_on').attr('checked', true);
}
