{**
 * ISC License
 *
 * Copyright (c) 2025 idnovate.com
 * idnovate is a Registered Trademark & Property of idnovate.com, innovación y desarrollo SCP
 *
 * Permission to use, copy, modify, and/or distribute this software for any
 * purpose with or without fee is hereby granted, provided that the above
 * copyright notice and this permission notice appear in all copies.
 *
 * THE SOFTWARE IS PROVIDED "AS IS" AND THE AUTHOR DISCLAIMS ALL WARRANTIES WITH
 * REGARD TO THIS SOFTWARE INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY
 * AND FITNESS. IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY SPECIAL, DIRECT,
 * INDIRECT, OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM
 * LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR
 * OTHER TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
 * PERFORMANCE OF THIS SOFTWARE.
 *
 * @author    idnovate
 * @copyright 2025 idnovate.com
 * @license   https://www.isc.org/licenses/ https://opensource.org/licenses/ISC ISC License
 *}
{if version_compare($smarty.const._PS_VERSION_,'1.6','<')}
	<div class="translatable">
		{foreach $languages as $language}
			<div class="lang_{$language.id_lang|intval}" style="display:{if $language.id_lang == $default_form_language}block{else}none{/if}; float: left;">
				{if isset($images[$language['id_lang']]) && $images[$language['id_lang']]}
					<img class="img-responsive" name="image_{$language.id_lang|intval}" id="image_{$language.id_lang|intval}" src="{$path|escape:'htmlall':'UTF-8'}{$image_dir|escape:'htmlall':'UTF-8'}{$images[$language['id_lang']|intval]|escape:'htmlall':'UTF-8'}?t={$smarty.now|escape:'htmlall':'UTF-8'}">

					<div class="clear"></div>
					<br />
					<a class="btn btn-default" href="{$delete_url|escape:'htmlall':'UTF-8'}&id_language={$language.id_lang|intval}">
						<i class="icon-trash"></i> {l s='Delete image' mod='advancedpopupcreator'}
					</a>
				{else}
					<img class="img-responsive" name="image_{$language.id_lang|intval}" id="image_{$language.id_lang|intval}" src="{$path|escape:'htmlall':'UTF-8'}{$image_dir|escape:'htmlall':'UTF-8'}noimage.gif">
				{/if}
			</div>
		{/foreach}
	</div>
{else}
	{foreach $languages as $language}
		{if $languages|count > 1}
		<div class="translatable-field lang-{$language['id_lang']|escape:'htmlall':'UTF-8'}" style="display: {if $language['id_lang'] == $default_form_language}block{else}none{/if};">
		{/if}
			<div class="col-lg-8">
				{if isset($images[$language['id_lang']]) && $images[$language['id_lang']]}
					<img class="img-responsive" name="image_{$language.id_lang|intval}" id="image_{$language.id_lang|intval}" src="{$path|escape:'htmlall':'UTF-8'}{$image_dir|escape:'htmlall':'UTF-8'}{$images[$language['id_lang']]|escape:'htmlall':'UTF-8'}?t={$smarty.now|escape:'htmlall':'UTF-8'}">
					<div class="clear"></div>
					<br />
					<a class="btn btn-default" href="{$delete_url|escape:'htmlall':'UTF-8'}&id_language={$language.id_lang|intval}">
						<i class="icon-trash"></i> {l s='Delete image' mod='advancedpopupcreator'}
					</a>
				{else}
					<img class="img-responsive" name="image_{$language.id_lang|intval}" id="image_{$language.id_lang|intval}" src="{$path|escape:'htmlall':'UTF-8'}{$image_dir|escape:'htmlall':'UTF-8'}noimage.gif">
				{/if}
			</div>
			{if $languages|count > 1}
			<div class="col-lg-2">
				<button type="button" class="btn btn-default dropdown-toggle" tabindex="-1" data-toggle="dropdown">
					{$language['iso_code']|escape:'htmlall':'UTF-8'}
					<span class="caret"></span>
				</button>
				<ul class="dropdown-menu">
					{foreach $languages as $language}
					<li><a href="javascript:hideOtherLanguage({$language['id_lang']|escape:'htmlall':'UTF-8'});" tabindex="-1">{$language['name']|escape:'htmlall':'UTF-8'}</a></li>
					{/foreach}
				</ul>
			</div>
		</div>
		{/if}
	{/foreach}
{/if}

<div class="clear"></div>

