<?php
/**
 * ISC License
 *
 * Copyright (c) 2025 idnovate.com
 * idnovate is a Registered Trademark & Property of idnovate.com, innovación y desarrollo SCP
 *
 * Permission to use, copy, modify, and/or distribute this software for any
 * purpose with or without fee is hereby granted, provided that the above
 * copyright notice and this permission notice appear in all copies.
 *
 * THE SOFTWARE IS PROVIDED "AS IS" AND THE AUTHOR DISCLAIMS ALL WARRANTIES WITH
 * REGARD TO THIS SOFTWARE INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY
 * AND FITNESS. IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY SPECIAL, DIRECT,
 * INDIRECT, OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM
 * LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR
 * OTHER TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
 * PERFORMANCE OF THIS SOFTWARE.
 *
 * @author    idnovate
 * @copyright 2025 idnovate.com
 * @license   https://www.isc.org/licenses/ https://opensource.org/licenses/ISC ISC License
 */
if (!defined('_PS_VERSION_')) {
    exit;
}

include_once _PS_MODULE_DIR_ . 'advancedpopupcreator/classes/AdvancedPopupCreatorIdnovateValidation.php';
include_once _PS_MODULE_DIR_ . 'advancedpopupcreator/classes/AdvancedPopup.php';

class AdvancedPopupCreator extends Module
{
    public static $image_dir = 'advancedpopupcreator/views/img/popup_images/';
    public $addons_id_product = '23773';

    public function __construct()
    {
        $this->name = 'advancedpopupcreator';
        $this->tab = 'front_office_features';
        $this->version = '1.2.1';
        $this->author = 'idnovate';
        $this->module_key = 'c5b68e4bc36b781f698da8607a515f18';
        // $this->author_address = '0xd89bcCAeb29b2E6342a74Bc0e9C82718Ac702160';
        $this->bootstrap = true;
        $this->ps_versions_compliancy = ['min' => '1.5', 'max' => _PS_VERSION_];

        parent::__construct();

        $this->displayName = $this->l('Advanced Popup Creator');
        $this->description = $this->l('Create as many popups as you can imagine: like loading the page, leaving the store, or when a product is added. Announce sales, new products, etc. and show it on any page: in categories, products, manufacturers... and divided up by clients.');

        if (empty($this->tabs)) {
            $this->tabs = [];
        }
        $tabs = $this->tabs;
        $tabs = array_merge($tabs, [
            [
                'class_name' => 'ADVANCEDPOPUPCREATOR',
                'parent_class_name' => 'IMPROVE',
                'name' => [
                    'en' => 'Popups',
                    'es' => 'Popups',
                ],
                'module' => $this->name,
                'icon' => 'star',
            ],
            [
                'class_name' => 'AdminAdvancedPopupCreatorConfiguration',
                'name' => [
                    'en' => 'General configuration',
                    'es' => 'Configuración general',
                ],
                'parent_class_name' => 'ADVANCEDPOPUPCREATOR',
                'module' => $this->name,
            ],
            [
                'class_name' => 'AdminAdvancedPopupCreatorPopups',
                'name' => [
                    'en' => 'Popups configuration',
                    'es' => 'Configuración de los Popups',
                ],
                'parent_class_name' => 'ADVANCEDPOPUPCREATOR',
                'module' => $this->name,
            ],
        ]);

        $this->tabs = $tabs;
    }

    public function install()
    {
        $result = true;

        $result &= parent::install();
        $result &= include dirname(__FILE__) . '/sql/install.php';
        $result &= $this->registerHook('displayHeader');
        $result &= (version_compare(_PS_VERSION_, '1.7', '>') || $this->registerHook('displayFooter'));
        $result &= (version_compare(_PS_VERSION_, '1.7', '<') || $this->registerHook('displayBeforeBodyClosingTag'));
        $result &= (version_compare(_PS_VERSION_, '1.5', '<') || $this->registerHook('displayPopups'));
        $result &= Configuration::updateValue('APC_HOOK_POSITION', 0);
        $result &= $this->installTabs($this->tabs);

        return (bool) $result;
    }

    public function uninstall()
    {
        $result = true;

        $result &= parent::uninstall();
        $result &= include dirname(__FILE__) . '/sql/uninstall.php';
        $result &= $this->uninstallTabs($this->tabs);
        $result &= Configuration::deleteByName('APC_HOOK_POSITION');
        $result &= Configuration::deleteByName('APC_HOOK_EXECUTED');
        $result &= $this->cleanDir(_PS_MODULE_DIR_ . self::$image_dir);

        return (bool) $result;
    }

    public function getContent()
    {
        Tools::redirectAdmin(Context::getContext()->link->getAdminLink('AdminAdvancedPopupCreatorPopups'));
    }

    public function hookDisplayHeader()
    {
        /*if (version_compare(_PS_VERSION_, '1.7', '>=')) {
            // Check if executed
            if (!Configuration::get('APC_HOOK_EXECUTED')) {
                Configuration::updateValue('APC_HOOK_EXECUTED', 1);
            } elseif (Configuration::get('APC_HOOK_EXECUTED') == 1) {
                if (!Configuration::get('APC_HOOK_POSITION')) {
                    Configuration::updateValue('APC_HOOK_POSITION', 0);
                }

                $availableHooks = array(
                    '1' => 'footer',
                    '2' => 'top',
                    '3' => 'displayBeforeBodyClosingTag',
                    '4' => 'displayNavFullWidth',
                    '5' => 'displayFooterLinks',
                    '6' => 'displayFooterLinks2',
                    '7' => 'displayFooterBuilder',
                    '8' => 'jxMegaLayoutFooter',
                    '9' => 'tmMegaLayoutFooter'
                );

                if (isset($availableHooks[(int)Configuration::get('APC_HOOK_POSITION') + 1])) {
                    if ((int)Configuration::get('APC_HOOK_POSITION')) {
                        $this->unregisterHook($availableHooks[(int)Configuration::get('APC_HOOK_POSITION')]);
                    }
                    $this->registerHook($availableHooks[(int)Configuration::get('APC_HOOK_POSITION') + 1]);

                    $cache_id = Hook::MODULE_LIST_BY_HOOK_KEY.(isset($this->context->shop->id) ? '_'.$this->context->shop->id : '').((isset($this->context->customer)) ? '_'.$this->context->customer->id : '');
                    Cache::clean($cache_id);

                    Configuration::updateValue('APC_HOOK_POSITION', (int)Configuration::get('APC_HOOK_POSITION')+1);
                } else {
                    Configuration::updateValue('APC_HOOK_EXECUTED', 2);
                }
            }
        }*/

        // Don't display popups in quick preview
        if ((int) Tools::getValue('content_only')) {
            return false;
        }

        if (Configuration::get('APC_BOOTSTRAP')) {
            // $this->context->controller->addCSS($this->_path . 'lib/bootstrap/bootstrap.min.css');
            $this->context->controller->addJS($this->_path . 'lib/bootstrap/bootstrap.min.js');
        }

        $this->context->controller->addCSS($this->_path . 'views/css/advancedpopup-front.css');
        $this->context->controller->addJS($this->_path . 'views/js/advancedpopup-front.js');

        $context = Context::getContext();

        $this->context->smarty->assign([
            'apc_link' => $this->context->link->getModuleLink('advancedpopupcreator', 'popup', [], Tools::usingSecureMode()),
            'apc_token' => Tools::getToken(false),
            'apc_product' => Tools::getValue('id_product'),
            'apc_category' => Tools::getValue('id_category'),
            'apc_supplier' => Tools::getValue('id_supplier'),
            'apc_manufacturer' => Tools::getValue('id_manufacturer'),
            'apc_cms' => Tools::getValue('id_cms'),
            'apc_controller' => self::getController(),
            'apc_exit_popups' => AdvancedPopup::existExitPopups(),
            'APC_CSS' => Configuration::get('APC_CSS'),
            'APC_JS' => Configuration::get('APC_JS'),
        ]);

        return $this->display(__FILE__, 'views/templates/hook/apc_functions_front.tpl');
    }

    public function hookDisplayTop()
    {
        return $this->hookDisplayFooter();
    }

    public function hookDisplayBeforeBodyClosingTag()
    {
        return $this->hookDisplayFooter();
    }

    public function hookDisplayNavFullWidth()
    {
        return $this->hookDisplayFooter();
    }

    public function hookDisplayPopups()
    {
        return $this->hookDisplayFooter();
    }

    public function hookDisplayFooterLinks()
    {
        return $this->hookDisplayFooter();
    }

    public function hookDisplayFooterLinks2()
    {
        return $this->hookDisplayFooter();
    }

    public function hookDisplayFooterBuilder()
    {
        return $this->hookDisplayFooter();
    }

    public function hookJxMegaLayoutFooter()
    {
        return $this->hookDisplayFooter();
    }

    public function hookTmMegaLayoutFooter()
    {
        return $this->hookDisplayFooter();
    }

    public function hookDisplayFooterAfter()
    {
        return $this->hookDisplayFooter();
    }

    public function hookDisplayFooter()
    {
        // Configuration::updateValue('APC_HOOK_EXECUTED', 2);
        if (isset($_SERVER['HTTP_USER_AGENT'])
            && Configuration::get('APC_UA')
            && preg_match('/' . Configuration::get('APC_UA') . '/i', $_SERVER['HTTP_USER_AGENT'])) {
            return;
        }

        $object = new AdvancedPopup();
        $popups = $object->getPopups(Tools::getValue('previewPopup') ? true : false);

        $tpl = '';

        foreach ($popups as $popup) {
            if (!$popup['content'] && !$popup['image'] && !$popup['image_background']) {
                continue;
            }

            $popupToDisplay = [];
            $popupToDisplay['lfSecsToDisplay'] = ((int) $popup['secs_to_display'] && $popup['display_on_load']) ? (int) $popup['secs_to_display'] * 1000 : 0;
            $popupToDisplay['lfSecsToDisplayCart'] = ((int) $popup['secs_to_display_cart'] && $popup['display_after_cart']) ? (int) $popup['secs_to_display_cart'] * 1000 : 0;
            $popupToDisplay['lfSecsToClose'] = (int) $popup['secs_to_close'] ?: 0;
            $popupToDisplay['lsBackOpacityValue'] = $popup['back_opacity_value'] ? (float) $popup['back_opacity_value'] : 0;
            $popupToDisplay['lsHeight'] = $popup['popup_height'];
            $popupToDisplay['lsHeightUnit'] = (int) $popup['popup_height_unit'] === 1 ? 'px' : '%';
            $popupToDisplay['lsWidth'] = $popup['popup_width'];
            $popupToDisplay['lsWidthUnit'] = (int) $popup['popup_width_unit'] === 1 ? 'px' : '%';
            $popupToDisplay['lsPadding'] = $popup['popup_padding'] ? (int) $popup['popup_padding'] : 0;
            $popupToDisplay['lbLocked'] = (bool) $popup['locked'];
            $popupToDisplay['lbCloseOnBackground'] = $popup['close_on_background'] ?: '0';
            $popupToDisplay['lsPopupCss'] = $popup['css'] ?: '';
            $popupToDisplay['lsPopupJs'] = $popup['js'] ?: '';
            $popupToDisplay['lsCssClass'] = $popup['css_class'] ?: '';
            $popupToDisplay['lsBlurBackground'] = $popup['blur_background'] ? $popup['blur_background'] : 0;
            $popupToDisplay['lsDisplayBackdrop'] = $popup['display_backdrop'] ?: 0;
            $popupToDisplay['popupId'] = $popup['id_advancedpopup'];
            $popupToDisplay['imageBackground'] = $popup['image_background'] ? _MODULE_DIR_ . AdvancedPopupCreator::$image_dir . $popup['image_background'] : '';
            $popupToDisplay['openEffect'] = $popup['open_effect'];
            $popupToDisplay['position'] = $popup['position'];
            $popupToDisplay['sticky_position'] = $popup['sticky_position'];
            $popupToDisplay['sticky_rotation'] = $popup['sticky_rotation'];
            $popupToDisplay['display_on_sticky'] = $popup['display_on_sticky'];
            $popupToDisplay['dontDisplayAgain'] = $popup['dont_display_again'];
            $popupToDisplay['colorBackground'] = $popup['color_background'];
            $popupToDisplay['sticky_display_close'] = $popup['sticky_display_close'];

            /*if (preg_match_all('/\powerfulform\:[(0-9\,)]+\}/i', $popup['content'], $matches)) {
                require_once _PS_MODULE_DIR_ . 'powerfulformgenerator/classes/PFGRenderer.php';
                foreach ($matches[0] as $match) {
                    $explode = explode(':', $match);
                    $popup['content'] = str_replace($match, AdvancedPopup::generatePFG(str_replace('}', '', $explode[1])), $popup['content']);
                }
            }

            if (Module::isInstalled('gformbuilderpro') && Module::isEnabled('gformbuilderpro')) {
                if (preg_match_all('/\gformbuilderpro\:[(0-9\,)]+\}/i', $popup['content'], $matches)) {
                    foreach ($matches[0] as $match) {
                        $formObj = Module::getInstanceByName('gformbuilderpro');
                        $formContent = $formObj->getFormByShortCode($match);
                        $popup['content'] = str_replace($match, $formContent, $popup['content']);
                    }
                }
            }*/

            $timestamp = strtotime($popup['date_upd']);
            $imageContent = '';
            if ($popup['image']) {
                if ($popup['image_link']) {
                    $this->context->smarty->assign([
                        'imageTarget' => $popup['image_link_target'],
                        'imageHref' => $popup['image_link'],
                    ]);
                }

                $this->context->smarty->assign([
                    'imageSrc' => _MODULE_DIR_ . AdvancedPopupCreator::$image_dir . $popup['image'] . '?t=' . $timestamp,
                ]);

                $imageContent .= $this->context->smarty->fetch(dirname(__FILE__) . '/views/templates/hook/apc_image.tpl');
            }

            $popupToDisplay['lsContent'] = $popup['content'] . $imageContent;
            $popupToDisplay['sticky_content'] = $popup['sticky_content'];

            // Assign vars
            $this->context->smarty->assign($popupToDisplay);

            $tpl .= $this->context->smarty->fetch(dirname(__FILE__) . '/views/templates/hook/apc_popup.tpl');
        }

        return $tpl;
    }

    public function hookDisplayOrderLeftColumn()
    {
        return $this->hookDisplayHeader();
    }

    public function installTabs($moduleTabs = null)
    {
        if (!$moduleTabs) {
            $moduleTabs = $this->tabs;
        }

        $languages = Language::getLanguages(false);

        foreach ($moduleTabs as $moduleTab) {
            if (!Tab::getIdFromClassName($moduleTab['class_name'])) {
                $tab = new Tab();
                $tab->class_name = $moduleTab['class_name'];
                $tab->module = $moduleTab['module'];
                $tab->active = 1;

                foreach ($languages as $language) {
                    if (is_array($moduleTab['name'])) {
                        if (isset($moduleTab['name'][$language['iso_code']])) {
                            $tab->name[$language['id_lang']] = $moduleTab['name'][$language['iso_code']];
                        } else {
                            $tab->name[$language['id_lang']] = $moduleTab['name']['en'];
                        }
                    } else {
                        $tab->name[$language['id_lang']] = $moduleTab['name'];
                    }
                }

                if (isset($moduleTab['parent_class_name']) && is_string($moduleTab['parent_class_name'])) {
                    $tab->id_parent = Tab::getIdFromClassName($moduleTab['parent_class_name']);
                } elseif (isset($moduleTab['id_parent'])) {
                    $tab->id_parent = $moduleTab['id_parent'];
                } else {
                    $tab->id_parent = -1;
                }

                if (isset($moduleTab['icon'])) {
                    $tab->icon = $moduleTab['icon'];
                }

                $tab->add();
                if (!$tab->id) {
                    return false;
                }
            }
        }

        return true;
    }

    public function uninstallTabs($moduleTabs = null)
    {
        if (!$moduleTabs) {
            $moduleTabs = $this->tabs;
        }

        foreach ($moduleTabs as $moduleTab) {
            $idTab = Tab::getIdFromClassName($moduleTab['class_name']);
            if ($idTab) {
                $tab = new Tab($idTab);
                $tab->delete();
            }
        }

        return true;
    }

    public static function cleanDir($lsDir, $removeDir = false)
    {
        if (is_dir($lsDir)) {
            $laFiles = scandir($lsDir);
            if (!empty($laFiles)) {
                unset($laFiles[0], $laFiles[1]);
                if (!empty($laFiles)) {
                    // Remove files
                    foreach ($laFiles as $lsFile) {
                        if ($lsFile != 'index.php' && $lsFile != 'noimage.gif') {
                            @unlink($lsDir . $lsFile);
                        }
                    }
                }
            }

            // Remove directory
            if ($removeDir) {
                @rmdir($lsDir);
            }
        }

        return true;
    }

    public static function uploadImage($path, $field, $langId, $object)
    {
        if (isset($_FILES[$field]) && !empty($_FILES[$field])) {
            $extension = '';

            if (!file_exists($path)) {
                if (!mkdir($path) && !is_dir($path)) {
                    throw new RuntimeException(sprintf('Directory "%s" was not created', $path));
                }
            }

            // Get extension
            $fileName = explode('.', $_FILES[$field]['name']);
            $extension = $fileName[count($fileName) - 1];

            // Remove the file if exists
            $newFilename = get_class($object) . $object->id . '_' . $field . '_' . $langId . '.' . $extension;
            if (file_exists($path . $newFilename)) {
                unlink($path . $newFilename);
            }

            if (move_uploaded_file($_FILES[$field]['tmp_name'], $path . $newFilename)) {
                return $newFilename;
            } else {
                return false;
            }
        }

        return false;
    }

    public static function deleteImage($path)
    {
        if (is_dir($path)) {
            return false;
        }

        if (!file_exists($path)) {
            return false;
        }

        if (!unlink($path)) {
            return false;
        }

        return true;
    }

    public static function convertPriceFull($amount, $currency_from = null, $currency_to = null, $round = true)
    {
        if ($currency_from === $currency_to) {
            return $amount;
        }

        if ($currency_from === null) {
            $currency_from = new Currency(Configuration::get('PS_CURRENCY_DEFAULT'));
        }

        if ($currency_to === null) {
            $currency_to = new Currency(Configuration::get('PS_CURRENCY_DEFAULT'));
        }

        if ($currency_from->id == Configuration::get('PS_CURRENCY_DEFAULT')) {
            $amount *= $currency_to->conversion_rate;
        } else {
            $conversion_rate = ($currency_from->conversion_rate == 0 ? 1 : $currency_from->conversion_rate);
            // Convert amount to default currency (using the old currency rate)
            $amount /= $conversion_rate;
            // Convert to new currency
            $amount *= $currency_to->conversion_rate;
        }
        if ($round) {
            $amount = Tools::ps_round($amount, _PS_PRICE_DISPLAY_PRECISION_);
        }

        return $amount;
    }

    public static function clearCache()
    {
        if (method_exists('Tools', 'clearAllCache')) {
            Tools::clearAllCache();
        }

        if (method_exists('Tools', 'clearSmartyCache')) {
            Tools::clearSmartyCache();
        }

        if (method_exists('Tools', 'clearSf2Cache')) {
            Tools::clearSf2Cache();
        }

        if (method_exists('Tools', 'clearCache')) {
            Tools::clearCache();
        }

        if (method_exists('Media', 'clearCache')) {
            Media::clearCache();
        }
    }

    public static function getController()
    {
        if ($controller = Tools::getValue('fromController')) {
            return $controller;
        }

        $cache_id = 'AdvancedPopupCreator::getController';

        if (Cache::isStored($cache_id)) {
            return Cache::retrieve($cache_id);
        }

        $module_name = '';
        if (Validate::isModuleName(Tools::getValue('module'))) {
            $module_name = Tools::getValue('module');
        }

        if (isset(Context::getContext()->controller->page_name) && Context::getContext()->controller->page_name) {
            $page_name = Context::getContext()->controller->page_name;
        } else {
            if ($page_name = Dispatcher::getInstance()->getController()) {
                $page_name = (preg_match('/^[0-9]/', $page_name)) ? 'page_' . $page_name : $page_name;
            } elseif (isset(Context::getContext()->controller->php_self)) {
                $page_name = Context::getContext()->controller->php_self;
            } elseif (Tools::getValue('fc') === 'module' && $module_name != '' && (Module::getInstanceByName($module_name) instanceof PaymentModule)) {
                $page_name = 'module-payment-submit';
            } elseif (preg_match('#^' . preg_quote(Context::getContext()->shop->physical_uri, '#') . 'modules/([a-zA-Z0-9_-]+?)/(.*)$#', $_SERVER['REQUEST_URI'], $m)) {
                // @retrocompatibility Are we in a module ?
                $page_name = 'module-' . $m[1] . '-' . str_replace(['.php', '/'], ['', '-'], $m[2]);
            }
        }

        // Exceptions
        // Backward compatibility of controller names
        if ($page_name === 'authentication') {
            $page_name = 'auth';
        } elseif ($page_name === 'productscomparison') {
            $page_name = 'compare';
        } elseif ($page_name === 'checkout') {
            // onepagecheckoutps
            $page_name = 'order';
        }/* elseif ($page_name === 'stores') {
            $page_name = 'cms';
        }*/

        $replace = ['-', '–'];
        $controller = str_replace($replace, '', $page_name);

        Cache::store($cache_id, $controller);

        return $controller;
    }

    public function getDatabaseVersion()
    {
        $query = 'SELECT `version`
            FROM `' . _DB_PREFIX_ . 'module`
            WHERE `name` = \'' . $this->name . '\';';

        return Db::getInstance()->getValue($query);
    }

    public static function checkOverride($className, $methodName)
    {
        // Check if the class is overridden
        $autoload = PrestaShopAutoload::getInstance();
        $classPath = $autoload->getClassPath($className);

        if ($classPath) {
            $overridePath = _PS_ROOT_DIR_ . '/' . $classPath;

            if (file_exists($overridePath)) {
                // Check if the method is overridden in the overridden class
                if (!class_exists($className, false)) {
                    require_once $overridePath;
                }
                $reflection = new ReflectionClass($className);

                if ($reflection->hasMethod($methodName)) {
                    return true;
                }
            }
        }

        return false;
    }

    public static function displayHooks($output, $hook_name, $hook_args, $id_module, $array_return, $check_exceptions, $use_push, $id_shop, $chain)
    {
        if (!Tools::getIsset('displayHooks')) {
            return $output;
        }

        if (!Tools::getValue('token')
            || Tools::getValue('token') !== Tools::getAdminToken('advancedpopupcreator')) {
            return $output;
        }

        if ($hook_name === 'displayOverrideTemplate') {
            return $output;
        }

        if (!strpos($hook_name, 'display') !== false) {
            return $output;
        }

        $colors = ['#FFF3AA', '#FFD0A8', '#FFB1B1', '#F4EFEC', '#D7E0B1', '#B5DCE1', '#FAF3DD'];
        $color = $colors[array_rand($colors, 1)];

        if (!$output) {
            $output = '<br />';
        }

        Context::getContext()->smarty->assign([
            'hook_name' => $hook_name,
            'adjustedColor' => self::adjustBrightness($color, -100),
            'color' => self::adjustBrightness($color, -100),
        ]);

        if (is_array($output)) {
            foreach ($output as $out) {
                Context::getContext()->smarty->assign([
                    'out' => $out,
                ]);
            }
        } else {
            Context::getContext()->smarty->assign([
                'out' => $output,
            ]);
        }

        return Context::getContext()->smarty->fetch(__FILE__, 'views/templates/hook/hook.tpl');
    }

    private static function adjustBrightness($hex, $steps)
    {
        // Steps should be between -255 and 255. Negative = darker, positive = lighter
        $steps = max(-255, min(255, $steps));

        // Normalize into a six character long hex string
        $hex = str_replace('#', '', $hex);
        if (strlen($hex) == 3) {
            $hex = str_repeat(substr($hex, 0, 1), 2) . str_repeat(substr($hex, 1, 1), 2) . str_repeat(substr($hex, 2, 1), 2);
        }

        // Split into three parts: R, G and B
        $color_parts = str_split($hex, 2);
        $return = '#';

        foreach ($color_parts as $color) {
            $color = hexdec($color); // Convert to decimal
            $color = max(0, min(255, $color + $steps)); // Adjust color
            $return .= str_pad(dechex($color), 2, '0', STR_PAD_LEFT); // Make two char hex code
        }

        return $return;
    }
}
