<?php
/**
 * ISC License
 *
 * Copyright (c) 2025 idnovate.com
 * idnovate is a Registered Trademark & Property of idnovate.com, innovación y desarrollo SCP
 *
 * Permission to use, copy, modify, and/or distribute this software for any
 * purpose with or without fee is hereby granted, provided that the above
 * copyright notice and this permission notice appear in all copies.
 *
 * THE SOFTWARE IS PROVIDED "AS IS" AND THE AUTHOR DISCLAIMS ALL WARRANTIES WITH
 * REGARD TO THIS SOFTWARE INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY
 * AND FITNESS. IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY SPECIAL, DIRECT,
 * INDIRECT, OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM
 * LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR
 * OTHER TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
 * PERFORMANCE OF THIS SOFTWARE.
 *
 * @author    idnovate
 * @copyright 2025 idnovate.com
 * @license   https://www.isc.org/licenses/ https://opensource.org/licenses/ISC ISC License
 */
if (!defined('_PS_VERSION_')) {
    exit;
}

function upgrade_module_1_0_4($module)
{
    $module->registerHook('header');
    $module->registerHook('footer');

    Db::getInstance()->execute(
        'ALTER TABLE `' . pSQL(_DB_PREFIX_ . $module->name) . '_configuration`
        ADD `name` VARCHAR(150) NOT NULL AFTER `id_shop`,
        ADD `display_on_load` tinyint(1) NOT NULL AFTER `active`,
        ADD `locked` tinyint(1) NOT NULL AFTER `priority`,
        CHANGE `display_after_cart` `display_after_cart` tinyint(1) NOT NULL AFTER `display_on_load`;'
    );

    $popups = Db::getInstance()->executeS(
        'SELECT *
        FROM `' . pSQL(_DB_PREFIX_ . $module->name) . '_configuration_lang`
        WHERE `id_lang` = ' . (int) Configuration::get('PS_LANG_DEFAULT')
    );

    Db::getInstance()->execute(
        'ALTER TABLE `' . pSQL(_DB_PREFIX_ . $module->name) . '_configuration_lang`
        ADD `css_class` VARCHAR(150) NULL AFTER `name`;'
    );

    Db::getInstance()->execute(
        'ALTER TABLE `' . pSQL(_DB_PREFIX_ . $module->name) . '_configuration_lang`
        DROP COLUMN `name`;'
    );

    foreach ($popups as $popup) {
        Db::getInstance()->execute(
            'UPDATE `' . pSQL(_DB_PREFIX_ . $module->name) . '_configuration`
            SET `name` = \'' . pSQL($popup['name']) . '\'
            WHERE `id_advancedpopup` = ' . (int) $popup['id_advancedpopup']
        );
    }

    return $module;
}
