<?php
/**
 * ISC License
 *
 * Copyright (c) 2025 idnovate.com
 * idnovate is a Registered Trademark & Property of idnovate.com, innovación y desarrollo SCP
 *
 * Permission to use, copy, modify, and/or distribute this software for any
 * purpose with or without fee is hereby granted, provided that the above
 * copyright notice and this permission notice appear in all copies.
 *
 * THE SOFTWARE IS PROVIDED "AS IS" AND THE AUTHOR DISCLAIMS ALL WARRANTIES WITH
 * REGARD TO THIS SOFTWARE INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY
 * AND FITNESS. IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY SPECIAL, DIRECT,
 * INDIRECT, OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM
 * LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR
 * OTHER TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
 * PERFORMANCE OF THIS SOFTWARE.
 *
 * @author    idnovate
 * @copyright 2025 idnovate.com
 * @license   https://www.isc.org/licenses/ https://opensource.org/licenses/ISC ISC License
 */
if (!defined('_PS_VERSION_')) {
    exit;
}

function upgrade_module_1_2_0($module)
{
    $columnExists = Db::getInstance()->getRow(
        "SELECT *
        FROM information_schema.COLUMNS
        WHERE
            TABLE_SCHEMA = '" . _DB_NAME_ . "'
            AND TABLE_NAME = '" . _DB_PREFIX_ . "advancedpopup'
            AND COLUMN_NAME = 'display_ip_string'"
    );

    if (!$columnExists) {
        $query = 'ALTER TABLE `' . _DB_PREFIX_ . 'advancedpopup`
            ADD `product_specific_price` tinyint(1) NOT NULL AFTER `display_ip_string`,
            ADD `display_inactive` tinyint(1) NOT NULL AFTER `display_on_click_selector`,
            ADD `secs_to_display_inactive` int unsigned NOT NULL AFTER `display_inactive`,
            ADD `product_oos` tinyint(1) NOT NULL AFTER `product_price_to`,
            ADD `product_oos_value` int NULL AFTER `product_oos`,
            ADD `display_on_sticky` tinyint(1) NOT NULL AFTER `secs_to_display_inactive`,
            ADD `sticky_display_close` tinyint NOT NULL AFTER `product_oos_value`,
            ADD `sticky_position` int NOT NULL AFTER `sticky_display_close`,
            ADD `sticky_rotation` int NOT NULL AFTER `sticky_position`,
            ADD `display_backdrop` tinyint(1) NOT NULL AFTER `blur_background`;';

        Db::getInstance()->execute($query);
    }

    $query = 'ALTER TABLE `' . _DB_PREFIX_ . 'advancedpopup`
        CHANGE `secs_to_display` `secs_to_display` int unsigned NULL AFTER `schedule`,
        CHANGE `secs_to_display_cart` `secs_to_display_cart` int unsigned NULL AFTER `secs_to_display`,
        CHANGE `secs_to_close` `secs_to_close` int unsigned NULL AFTER `secs_to_display_cart`,        
        CHANGE `open_effect` `open_effect` varchar(32) NULL AFTER `color_background`;';

    Db::getInstance()->execute($query);

    $columnExists = Db::getInstance()->getRow(
        "SELECT *
        FROM information_schema.COLUMNS
        WHERE
            TABLE_SCHEMA = '" . _DB_NAME_ . "'
            AND TABLE_NAME = '" . _DB_PREFIX_ . "advancedpopup_lang'
            AND COLUMN_NAME = 'popup_height_unit'"
    );

    if (!$columnExists) {
        $query = 'ALTER TABLE `' . _DB_PREFIX_ . 'advancedpopup_lang`
            ADD `popup_height_unit` int unsigned NULL AFTER `popup_height`,
            ADD `popup_width_unit` int unsigned NULL AFTER `popup_width`,
            ADD `sticky_content` text NULL;';

        Db::getInstance()->execute($query);

        $query = 'UPDATE `' . _DB_PREFIX_ . 'advancedpopup_lang`
            SET `popup_height_unit` = 1,
                `popup_width_unit` = 1;';

        Db::getInstance()->execute($query);
    }

    Configuration::updateValue('APC_BOOTSTRAP', 1);

    $module->installTabs();

    // Remove old tab
    $idTab = Tab::getIdFromClassName('AdminAdvancedPopupCreator');
    if ($idTab) {
        $tab = new Tab($idTab);
        $tab->delete();
    }

    return true;
}
