/**
 * ISC License
 *
 * Copyright (c) 2025 idnovate.com
 * idnovate is a Registered Trademark & Property of idnovate.com, innovación y desarrollo SCP
 *
 * Permission to use, copy, modify, and/or distribute this software for any
 * purpose with or without fee is hereby granted, provided that the above
 * copyright notice and this permission notice appear in all copies.
 *
 * THE SOFTWARE IS PROVIDED "AS IS" AND THE AUTHOR DISCLAIMS ALL WARRANTIES WITH
 * REGARD TO THIS SOFTWARE INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY
 * AND FITNESS. IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY SPECIAL, DIRECT,
 * INDIRECT, OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM
 * LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR
 * OTHER TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
 * PERFORMANCE OF THIS SOFTWARE.
 *
 * @author    idnovate
 * @copyright 2025 idnovate.com
 * @license   https://www.isc.org/licenses/ https://opensource.org/licenses/ISC ISC License
 */

$('.textarea-autosize.apc_tiny').removeClass('textarea-autosize');

$(document).ready(function(){
    if (typeof(tinySetup) != "undefined") {
        /*if (typeof(module_dir) == "undefined") {
            var module_dir = '/modules/';
        }*/

        tinySetup({
            editor_selector: "apc_tiny",
            valid_children: "+body[style|script|iframe|section|link],pre[iframe|section|script|div|p|br|span|img|style|h1|h2|h3|h4|h5],*[*]",
            forced_root_block: '',
            external_plugins: {
                "filemanager": ad + "/filemanager/plugin.min.js",
                'codemirror': module_dir + "advancedpopupcreator/lib/tiny_mce/codemirror/plugin.min.js"
            },
            codemirror: {
                indentOnInit: true,
                path: '../../CodeMirror',
            }
        });
    }

    //Apply CodeMirror in JS field
    $('.codemirror.codemirror-js').each(function () {
        CodeMirror.fromTextArea($(this)[0], {
            mode: "javascript",
            theme: "monokai",
            autoRefresh: true,
            lineNumbers: true,
            lineWrapping: true,
            styleActiveLine: true,
            'CodeMirror-lines': 10
        });
    });

    //Apply CodeMirror in CSS field
    $('.codemirror.codemirror-css').each(function () {
        CodeMirror.fromTextArea($(this)[0], {
            mode: "css",
            theme: "monokai",
            autoRefresh: true,
            lineNumbers: true,
            lineWrapping: true,
            styleActiveLine: true,
            'CodeMirror-lines': 10
        });
    });

    //Enable switches for inputs/selects with values
    $("[class^='switch_']").not('div').each(function () {
        let elementClass = $(this).attr('class').split(" ").filter(function(n) {
          if(/switch/.test(n)) return n;
        });
        var that = this;
        elementClass.forEach(function(element) {
            if ($(that).is('input')) {
                if ($(that).val().length > 0) {
                    $('#'+element+'_on').attr('checked', true);
                    $(that).closest('.form-wrapper > .form-group').show();
                };
            } else if ($(that).is('select')) {
                if (!$(that).hasClass('selectedSwap')) {
                    return;
                }
                if ($(that).find('option').length > 0) {
                    $('#'+element+'_on').attr('checked', true);
                    $(that).closest('.form-wrapper > .form-group').show().find('*').not('script').show();
                }
            }
        });
    });

    // Display/hide values when switch changes
    $("[name^=switch_], [name=display_on_load], [name=display_after_cart], [name=display_inactive], [name=display_on_click], [name=cart_amount], [name=product_stock], [name=product_price], [name=product_oos], [name='display_backdrop']").change(function() {
        toggleFilters();
    });

    toggleFilters();
});

/*if (fieldName === 'categories_selected[]_selected[]') {
            if ($(this).find('option').length === "0") {
                $(this).closest('.form-group').next().hide().next().hide();
            } else {
                $(this).closest('.form-group').next().show().next().show();
            }
        }*/

function toggleFilters() {
    $('[name=display_on_load]:checked, [name=display_after_cart]:checked, [name=display_inactive]:checked, [name=display_on_click]:checked, [name=cart_amount]:checked, [name=product_stock]:checked, [name=product_price]:checked, [name=product_oos]:checked, [name=switch_categories_selected]:checked, [name=display_backdrop]:checked').each(function () {
        var fieldName = $(this).attr('name');
        if (fieldName === 'switch_categories_selected' || fieldName === 'display_backdrop') {
            if ($(this).val() === "0") {
                $(this).closest('.form-group').next().hide().next().hide();
            } else {
                $(this).closest('.form-group').next().show().next().show();
            }
        } else if (fieldName === 'cart_amount' || fieldName === 'product_stock' || fieldName === 'product_price') {
            if ($(this).val() === "0") {
                $(this).closest('.form-group').nextAll().slice(0,2).hide();
            } else {
                $(this).closest('.form-group').nextAll().slice(0,2).show();
            }
        } else {
            if ($(this).val() === "0") {
                $(this).closest('.form-group').next().hide();
                $('.'+$(this).attr('name')+', #'+$(this).attr('name')+', #'+$(this).attr('name')+'_minimum, #'+$(this).attr('name')+'_maximum').not('div').closest('.form-wrapper > .form-group').hide();
                $('.'+$(this).attr('name')+', #'+$(this).attr('name')+', #'+$(this).attr('name')+'_minimum, #'+$(this).attr('name')+'_maximum').not('div').closest('.margin-group').hide();
                $('.'+$(this).attr('name')+', #'+$(this).attr('name')+', #'+$(this).attr('name')+'_minimum, #'+$(this).attr('name')+'_maximum').not('div').closest('.swap-container-custom').hide();
                $('.'+$(this).attr('name')+', #'+$(this).attr('name')+', #'+$(this).attr('name')+'_minimum, #'+$(this).attr('name')+'_maximum').not('div').closest('.margin-form').hide().prev().hide();
                $('.'+$(this).attr('name')+', #'+$(this).attr('name')+', #'+$(this).attr('name')+'_minimum, #'+$(this).attr('name')+'_maximum').not('div').closest('.panel > .form-group').hide();
            } else {
                $(this).closest('.form-group').next().show();
                $('.'+$(this).attr('name')+', #'+$(this).attr('name')+', #'+$(this).attr('name')+'_minimum, #'+$(this).attr('name')+'_maximum').not('div').closest('.form-wrapper > .form-group').show();
                $('.'+$(this).attr('name')+', #'+$(this).attr('name')+', #'+$(this).attr('name')+'_minimum, #'+$(this).attr('name')+'_maximum').not('div').closest('.margin-group').show();
                $('.'+$(this).attr('name')+', #'+$(this).attr('name')+', #'+$(this).attr('name')+'_minimum, #'+$(this).attr('name')+'_maximum').not('div').closest('.swap-container-custom').show();
                $('.'+$(this).attr('name')+', #'+$(this).attr('name')+', #'+$(this).attr('name')+'_minimum, #'+$(this).attr('name')+'_maximum').not('div').closest('.margin-form').show().prev().show();
                $('.'+$(this).attr('name')+', #'+$(this).attr('name')+', #'+$(this).attr('name')+'_minimum, #'+$(this).attr('name')+'_maximum').not('div').closest('.panel > .form-group').show();
            }
        }
    });

    $('[name^=switch_]:checked').each(function () {
        if ($(this).val() === "0") {
            $('.'+$(this).attr('name')+', #'+$(this).attr('name')+', #'+$(this).attr('name')+'_minimum, #'+$(this).attr('name')+'_maximum').not('div').closest('.form-wrapper > .form-group').hide();
            $('.'+$(this).attr('name')+', #'+$(this).attr('name')+', #'+$(this).attr('name')+'_minimum, #'+$(this).attr('name')+'_maximum').not('div').closest('.margin-group').hide();
            $('.'+$(this).attr('name')+', #'+$(this).attr('name')+', #'+$(this).attr('name')+'_minimum, #'+$(this).attr('name')+'_maximum').not('div').closest('.swap-container-custom').hide();
            $('.'+$(this).attr('name')+', #'+$(this).attr('name')+', #'+$(this).attr('name')+'_minimum, #'+$(this).attr('name')+'_maximum').not('div').closest('.margin-form').hide().prev().hide();
            $('.'+$(this).attr('name')+', #'+$(this).attr('name')+', #'+$(this).attr('name')+'_minimum, #'+$(this).attr('name')+'_maximum').not('div').closest('.panel > .form-group').hide();
        } else {
            $('.'+$(this).attr('name')+', #'+$(this).attr('name')+', #'+$(this).attr('name')+'_minimum, #'+$(this).attr('name')+'_maximum').not('div').closest('.form-wrapper > .form-group').show();
            $('.'+$(this).attr('name')+', #'+$(this).attr('name')+', #'+$(this).attr('name')+'_minimum, #'+$(this).attr('name')+'_maximum').not('div').closest('.margin-group').show();
            $('.'+$(this).attr('name')+', #'+$(this).attr('name')+', #'+$(this).attr('name')+'_minimum, #'+$(this).attr('name')+'_maximum').not('div').closest('.swap-container-custom').show();
            $('.'+$(this).attr('name')+', #'+$(this).attr('name')+', #'+$(this).attr('name')+'_minimum, #'+$(this).attr('name')+'_maximum').not('div').closest('.margin-form').show().prev().show();
            $('.'+$(this).attr('name')+', #'+$(this).attr('name')+', #'+$(this).attr('name')+'_minimum, #'+$(this).attr('name')+'_maximum').not('div').closest('.panel > .form-group').show();
        }
    });
}
